/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import com.appier.ads.AppierError;
import com.appier.ads.common.Identifier;
import com.appier.ads.network.Request;
import com.appier.ads.network.Response;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AppierBaseAd {
    private static final String LOG_TAG = "AppierMediation";
    private String mNetworkHost = "https://ad3.apx.appier.net";
    private String mAdPath = "/v1/sdk/ad";
    private Context mContext;
    private BaseAdEventListener mBaseAdEventListener;
    private Identifier mIdentifier;
    private AdvertisingIdClient.Info mAdInfo;
    private Request mReqAd;
    private Response mResAd;
    private JSONObject mAdJSON;

    public AppierBaseAd(Context context) {
        this.mContext = context;
        this.mIdentifier = new Identifier(context);
    }

    public void setBaseAdEventListener(BaseAdEventListener eventListener) {
        this.mBaseAdEventListener = eventListener;
    }

    public void setNetworkHost(String networkHost) {
        this.mNetworkHost = networkHost;
    }

    public void setAdPath(String adPath) {
        this.mAdPath = adPath;
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getNetworkHost() {
        return this.mNetworkHost;
    }

    public String getAdPath() {
        return this.mAdPath;
    }

    public Identifier getIdentifier() {
        return this.mIdentifier;
    }

    public AdvertisingIdClient.Info getAdInfo() {
        return this.mAdInfo;
    }

    public String getRawAd() {
        return this.mResAd.getResponseText();
    }

    public JSONObject getAdJSON() {
        return this.mAdJSON;
    }

    public void loadAd() {
        AdvertisingIdClient.Info adInfo = this.mIdentifier.getCachedAdInfo();
        if (adInfo != null) {
            this.internalLoadAd();
        } else {
            this.mIdentifier.getAdInfo(new Identifier.EventListener(){

                @Override
                public void onAdInfoFetched(AdvertisingIdClient.Info adInfo) {
                    AppierBaseAd.this.mAdInfo = adInfo;
                    AppierBaseAd.this.internalLoadAd();
                }
            });
        }
    }

    private void internalLoadAd() {
        String adUri = this.getAdUri();
        this.mReqAd = Request.newRequest(adUri);
        this.mReqAd.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                AppierBaseAd.this.mResAd = response;
                int adResCode = AppierBaseAd.this.mResAd.getResponseCode();
                if (adResCode == -1) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.NETWORK_ERROR);
                } else if (adResCode == 200) {
                    String ad = AppierBaseAd.this.getRawAd();
                    try {
                        AppierBaseAd.this.mAdJSON = new JSONObject(ad);
                        AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoaded(AppierBaseAd.this, false);
                    }
                    catch (JSONException e) {
                        AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.INVALID_JSON);
                    }
                } else if (adResCode == 204) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoaded(AppierBaseAd.this, true);
                } else if (400 <= adResCode && adResCode <= 499) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.BAD_REQUEST);
                } else if (500 <= adResCode && adResCode <= 599) {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.INTERNAL_SERVER_ERROR);
                } else {
                    AppierBaseAd.this.mBaseAdEventListener.onBaseAdLoadFail(AppierError.UNKNOWN_ERROR);
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Response res = AppierBaseAd.this.mReqAd.executeAndWait();
                Request.Callback requestCallback = AppierBaseAd.this.mReqAd.getCallback();
                requestCallback.onCompleted(res);
            }
        };
        new Thread(runnable).start();
    }

    public abstract String getAdUri();

    public static interface BaseAdEventListener {
        public void onBaseAdLoaded(AppierBaseAd var1, boolean var2);

        public void onBaseAdLoadFail(AppierError var1);
    }
}

