/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.view.View;
import com.appier.ads.common.BaseWebView;

public class AppierBannerView
extends BaseWebView {
    Context mContext;
    EventListener mEventListener;

    public AppierBannerView(Context context, EventListener eventListener) {
        super(context);
        this.mContext = context;
        this.mEventListener = eventListener;
        this.setOnTouchListener(new WebViewListener());
    }

    public void loadHtml(final String html) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                AppierBannerView.this.loadDataWithBaseURL("about:blank", html, "text/html", "utf-8", null);
            }
        });
    }

    public void loadCreative(String creative) {
        String html = "<html><head></head><body style=\"margin:0;padding:0\">" + creative + "</body></html>";
        this.loadHtml(html);
    }

    static interface EventListener {
        public void onClick();
    }

    private class WebViewListener
    implements View.OnTouchListener {
        private static final long MAX_TOUCH_DURATION = 500L;
        private long mDownTime;

        private WebViewListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    this.mDownTime = event.getEventTime();
                    break;
                }
                case 1: {
                    if (event.getEventTime() - this.mDownTime > 500L) break;
                    AppierBannerView.this.mEventListener.onClick();
                    break;
                }
            }
            return false;
        }
    }
}

