/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads;

import android.content.Context;
import android.net.Uri;
import com.appier.ads.AppierBaseAd;
import com.appier.ads.AppierError;
import com.appier.ads.common.Identifier;
import com.appier.ads.network.Network;
import com.appier.ads.network.Request;
import com.appier.ads.network.Response;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class AppierNativeAd
extends AppierBaseAd
implements AppierBaseAd.BaseAdEventListener {
    private EventListener mEventListener;
    private String mZoneId;
    private Request mReqImpTrack;
    private Response mResImpTrack;

    public AppierNativeAd(Context context, EventListener eventListener) {
        super(context);
        this.setBaseAdEventListener(this);
        this.mEventListener = eventListener;
    }

    public void loadAd(String zoneId) {
        this.mZoneId = zoneId;
        super.loadAd();
    }

    @Override
    public String getAdUri() {
        String networkHost = this.getNetworkHost();
        String adPath = this.getAdPath();
        Identifier identifier = this.getIdentifier();
        AdvertisingIdClient.Info adInfo = this.getAdInfo();
        boolean isLATEnabled = adInfo == null || adInfo.isLimitAdTrackingEnabled();
        Uri adUri = Uri.parse((String)(networkHost + adPath)).buildUpon().appendQueryParameter("zoneid", this.mZoneId).appendQueryParameter("bundle", this.getContext().getPackageName()).appendQueryParameter("ia", isLATEnabled ? "" : adInfo.getId()).appendQueryParameter("type", "adid").appendQueryParameter("lat", isLATEnabled ? "1" : "0").appendQueryParameter("locale", Locale.getDefault().toString()).appendQueryParameter("sdk_version", "1.0.0-rc2").appendQueryParameter("conntype", Network.getType(this.getContext()).toString()).appendQueryParameter("country", identifier.getTelCountry()).appendQueryParameter("operator", identifier.getTelNetworkOperator()).appendQueryParameter("operator_name", identifier.getTelNetworkOperatorName()).build();
        return adUri.toString();
    }

    private JSONObject getAd() throws JSONException {
        return this.getAdJSON().getJSONArray("adUnits").getJSONObject(0).getJSONObject("ad");
    }

    public String getTitle() throws JSONException {
        return this.getAd().getJSONObject("native").getString("title");
    }

    public String getText() throws JSONException {
        return this.getAd().getJSONObject("native").getString("text");
    }

    public String getIconImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("iconImage").getString("url");
    }

    public String getMainImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("mainImage").getString("url");
    }

    public String getCallToActionText() throws JSONException {
        return this.getAd().getJSONObject("native").getString("ctaText");
    }

    public String getImpressionTrackerUrl() throws JSONException {
        return this.getAd().getJSONArray("impTracker").getString(0);
    }

    public String getClickDestinationUrl() throws JSONException {
        return this.getAd().getString("clk");
    }

    public String getPrivacyInformationIconImageUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("privacyInformationIcon").getString("url");
    }

    public String getPrivacyInformationIconClickThroughUrl() throws JSONException {
        return this.getAd().getJSONObject("native").getJSONObject("privacyInformationLink").getString("url");
    }

    public List<String> getCacheableImageUrls() {
        ArrayList<String> imageUrls = new ArrayList<String>();
        try {
            imageUrls.add(this.getIconImageUrl());
            imageUrls.add(this.getMainImageUrl());
            imageUrls.add(this.getPrivacyInformationIconImageUrl());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            return imageUrls;
        }
    }

    public void makeImpressionTrackingRequest() throws JSONException {
        String impTracker = this.getImpressionTrackerUrl();
        this.mReqImpTrack = Request.newRequest(impTracker);
        this.mReqImpTrack.setCallback(new Request.Callback(){

            @Override
            public void onCompleted(Response response) {
                AppierNativeAd.this.mResImpTrack = response;
                if (AppierNativeAd.this.mResImpTrack.getResponseCode() == 200) {
                    AppierNativeAd.this.mEventListener.onImpressionRecorded(AppierNativeAd.this);
                } else {
                    AppierNativeAd.this.mEventListener.onImpressionRecordFail(AppierError.UNKNOWN_ERROR, AppierNativeAd.this);
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Response res = AppierNativeAd.this.mReqImpTrack.executeAndWait();
                Request.Callback requestCallback = AppierNativeAd.this.mReqImpTrack.getCallback();
                requestCallback.onCompleted(res);
            }
        };
        new Thread(runnable).start();
    }

    @Override
    public void onBaseAdLoaded(AppierBaseAd ad, boolean isNoBid) {
        if (isNoBid) {
            this.mEventListener.onAdNoBid(this);
        } else {
            this.mEventListener.onAdLoaded(this);
        }
    }

    @Override
    public void onBaseAdLoadFail(AppierError appierError) {
        this.mEventListener.onAdLoadFail(appierError, this);
    }

    public static interface EventListener {
        public void onAdLoaded(AppierNativeAd var1);

        public void onAdNoBid(AppierNativeAd var1);

        public void onAdLoadFail(AppierError var1, AppierNativeAd var2);

        public void onImpressionRecorded(AppierNativeAd var1);

        public void onImpressionRecordFail(AppierError var1, AppierNativeAd var2);
    }
}

