/*
 * Decompiled with CFR 0.152.
 */
package com.appier.ads.network;

import com.appier.ads.network.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class Request {
    private Callback callback;
    private final JSONObject jsonObject;
    private final Map<String, String> headers;
    private final String urlString;
    private final String method;
    private int readTimeout;
    private int connectionTimeout;

    private Request(String url, String method, JSONObject jsonObject) {
        this.urlString = url;
        this.method = method;
        this.jsonObject = jsonObject;
        this.headers = new HashMap<String, String>();
        this.readTimeout = 1000;
        this.connectionTimeout = 2000;
    }

    public static Request newRequest(String url) {
        return new Request(url, "GET", null);
    }

    public static Request newRequest(String url, JSONObject jsonObject) {
        return new Request(url, "POST", jsonObject);
    }

    public Callback getCallback() {
        return this.callback;
    }

    public final Request setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public Request setReadTimeout(int readTimeoutInSeconds) {
        this.readTimeout = readTimeoutInSeconds * 1000;
        return this;
    }

    public Request setRequestHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response execute(byte[] sendableBytes) {
        Request request = this;
        HttpURLConnection urlConnection = null;
        int responseCode = -1;
        try {
            String line;
            URL url = new URL(this.urlString);
            urlConnection = (HttpURLConnection)url.openConnection();
            for (String header : this.headers.keySet()) {
                urlConnection.setRequestProperty(header, this.headers.get(header));
            }
            if (sendableBytes != null) {
                urlConnection.setDoOutput(true);
            }
            urlConnection.setRequestMethod(this.method);
            urlConnection.setConnectTimeout(this.connectionTimeout);
            urlConnection.setReadTimeout(this.readTimeout);
            urlConnection.connect();
            if (sendableBytes != null) {
                OutputStream outputStream = urlConnection.getOutputStream();
                outputStream.write(sendableBytes);
            }
            responseCode = urlConnection.getResponseCode();
            InputStream inputStream = urlConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            StringBuilder responseString = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                responseString.append(line);
            }
            bufferedReader.close();
            Response response = Response.constructResponse(request, responseString.toString(), responseCode, false);
            return response;
        }
        catch (MalformedURLException e) {
            Response response = Response.constructResponse(request, "MalformedURLException", responseCode, true);
            return response;
        }
        catch (IOException e) {
            Response response = Response.constructResponse(request, "IOException", responseCode, true);
            return response;
        }
        catch (OutOfMemoryError e) {
            Response response = Response.constructResponse(request, "OutOfMemoryError", responseCode, true);
            return response;
        }
        catch (Exception e) {
            Response response = Response.constructResponse(request, e.toString(), responseCode, true);
            return response;
        }
        catch (Error e) {
            Response response = Response.constructResponse(request, e.toString(), responseCode, true);
            return response;
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public Response executeAndWait() {
        byte[] sendingBytes = null;
        if (this.jsonObject != null) {
            String originalString = this.jsonObject.toString();
            sendingBytes = originalString.getBytes();
        }
        return this.execute(sendingBytes);
    }

    public static interface Callback {
        public void onCompleted(Response var1);
    }
}

