/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors;

import com.appdynamics.android.bci.bytecodeinjectors.BaseClassVisitor;
import com.appdynamics.android.bci.features.ClassVisitorFactory;
import com.appdynamics.android.bci.util.ClassUtil;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;

public class BuildIdInjector
extends BaseClassVisitor {
    private static final String ACTIVITY_CLASS = "android/app/Activity";
    private static final String CLASS_INIT_METHOD = "<clinit>";
    private static final String CLASS_INIT_METHOD_DESCRIPTOR = "()V";
    private static final String BUILD_INFO_CLASS = "com/appdynamics/eumagent/runtime/BuildInfo";
    private static final String BUILD_ID_FIELD_PREFIX = "appdynamicsGeneratedBuildId_";
    private static final String THROWABLE_CLASS = "java/lang/Throwable";
    private boolean isTargetClass;
    private boolean hasSeenClassInitMethod;
    private final ClassUtil classUtil;
    private final String buildId;

    public BuildIdInjector(ClassVisitor cv, ClassUtil classUtil, String buildId) {
        super(cv);
        this.classUtil = classUtil;
        this.buildId = buildId;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.hasSeenClassInitMethod = false;
        boolean bl = this.isTargetClass = !name.startsWith("android/") && superName.startsWith("android/") && this.classUtil.getCommonSuperClass(ACTIVITY_CLASS, name).equals(ACTIVITY_CLASS);
        if (this.isTargetClass) {
            this.logger.debug("Found a descendant of %s class: %s", ACTIVITY_CLASS, this.className);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.isTargetClass && CLASS_INIT_METHOD.equals(name)) {
            this.hasSeenClassInitMethod = true;
            this.logger.debug("Found <clinit> method, adding buildId to it", new Object[0]);
            return new BuildIdInjectorMethodVisitor(baseMV, access, name, desc);
        }
        return baseMV;
    }

    @Override
    public void visitEnd() {
        if (this.isTargetClass && !this.hasSeenClassInitMethod) {
            this.logger.debug("Did not find <clinit> method for class %s, adding it", this.className);
            MethodVisitor baseMV = super.visitMethod(8, CLASS_INIT_METHOD, CLASS_INIT_METHOD_DESCRIPTOR, null, null);
            BuildIdInjectorMethodVisitor injectorMV = new BuildIdInjectorMethodVisitor(baseMV, 8, CLASS_INIT_METHOD, CLASS_INIT_METHOD_DESCRIPTOR);
            injectorMV.visitCode();
            injectorMV.visitInsn(177);
            injectorMV.visitMaxs(0, 0);
            injectorMV.visitEnd();
        }
        super.visitEnd();
    }

    public static class Factory
    implements ClassVisitorFactory {
        private final ClassUtil classUtil;
        private final String id;

        public Factory(ClassUtil classUtil, String id) {
            this.classUtil = classUtil;
            this.id = id;
        }

        @Override
        public ClassVisitor createClassVisitor(ClassVisitor delegate) {
            return new BuildIdInjector(delegate, this.classUtil, this.id);
        }
    }

    private class BuildIdInjectorMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        private final Label tryStartLabel;
        private final Label tryEndLabel;
        private final Label catchStartLabel;
        private final Label catchEndLabel;

        BuildIdInjectorMethodVisitor(MethodVisitor mv, int access, String methodName, String methodDesc) {
            super(mv, access, methodName, methodDesc);
            this.tryStartLabel = new Label();
            this.tryEndLabel = new Label();
            this.catchStartLabel = new Label();
            this.catchEndLabel = new Label();
        }

        @Override
        public void visitCode() {
            this.mv.visitCode();
            String BUILD_ID_FIELD = BuildIdInjector.BUILD_ID_FIELD_PREFIX + BuildIdInjector.this.buildId;
            String BOOL_DESC = Type.getDescriptor(Boolean.TYPE);
            this.mv.visitTryCatchBlock(this.tryStartLabel, this.tryEndLabel, this.catchStartLabel, BuildIdInjector.THROWABLE_CLASS);
            this.mv.visitLabel(this.tryStartLabel);
            this.mv.visitFieldInsn(178, BuildIdInjector.BUILD_INFO_CLASS, BUILD_ID_FIELD, BOOL_DESC);
            Label elseBlock = new Label();
            Label elseBlockEnd = new Label();
            this.mv.visitJumpInsn(154, elseBlockEnd);
            this.mv.visitInsn(4);
            this.mv.visitFieldInsn(179, BuildIdInjector.BUILD_INFO_CLASS, BUILD_ID_FIELD, BOOL_DESC);
            this.mv.visitJumpInsn(167, elseBlockEnd);
            this.mv.visitLabel(elseBlock);
            this.mv.visitInsn(3);
            this.mv.visitFieldInsn(179, BuildIdInjector.BUILD_INFO_CLASS, BUILD_ID_FIELD, BOOL_DESC);
            this.mv.visitLabel(elseBlockEnd);
            this.mv.visitLabel(this.tryEndLabel);
            this.mv.visitJumpInsn(167, this.catchEndLabel);
            this.mv.visitLabel(this.catchStartLabel);
            this.mv.visitInsn(87);
            this.mv.visitLabel(this.catchEndLabel);
        }
    }
}

