/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.bytecodeinjectors.config;

import com.appdynamics.android.bci.bytecodeinjectors.GenericInjector;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.snakeyaml.Yaml;
import com.appdynamics.repackaged.snakeyaml.constructor.Constructor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class GenericInjectorConfig {
    private static final BCILogger logger = BCILogger.getLoggerFor(GenericInjectorConfig.class);

    private GenericInjectorConfig() {
    }

    private static String listInterceptors() {
        String interceptorList = "interceptorList.yml";
        InputStream input = GenericInjectorConfig.class.getResourceAsStream("interceptorList.yml");
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        StringBuilder sb = new StringBuilder("Supported Interceptors:");
        sb.append(System.lineSeparator());
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().startsWith("#")) continue;
                sb.append(line).append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            logger.error(e, "Error reading interceptorList.yml");
        }
        BuildUtils.closeQuietly(reader);
        return sb.toString();
    }

    private static InputStream getInputStream(String ymlFile) {
        String fileName;
        InputStream input;
        if (ymlFile == null) {
            return null;
        }
        File file = new File(ymlFile);
        if (file.canRead()) {
            try {
                FileInputStream input2 = new FileInputStream(file);
                return input2;
            }
            catch (FileNotFoundException e) {
                logger.info("WARNING: Could not open YAML file at path: %s", ymlFile);
            }
        }
        if ((input = GenericInjectorConfig.class.getResourceAsStream(fileName = ymlFile.endsWith(".yml") ? ymlFile : ymlFile + ".yml")) == null) {
            logger.error("ERROR: Could not open resource: %s", fileName);
            logger.info(GenericInjectorConfig.listInterceptors(), new Object[0]);
            throw new RuntimeException("No interceptor for: " + fileName);
        }
        return input;
    }

    public static List<GenericInjector.ClassInfo> getInterceptors(String fileName) {
        InputStream inputStream = GenericInjectorConfig.getInputStream(fileName);
        List<GenericInjector.ClassInfo> interceptors = GenericInjectorConfig.getInterceptors(inputStream);
        BuildUtils.closeQuietly(inputStream);
        return interceptors;
    }

    public static List<GenericInjector.ClassInfo> getInterceptors(InputStream input) {
        ArrayList<GenericInjector.ClassInfo> list = new ArrayList<GenericInjector.ClassInfo>();
        if (input == null) {
            return list;
        }
        Interceptor interceptor = Interceptor.load(input);
        BCIRunSummary.addFeature(BCIRunSummary.Feature.Type.NET, interceptor.feature, interceptor.info);
        for (Target target : interceptor.targets) {
            for (String method : target.methods.keySet()) {
                String signature = target.methods.get(method);
                list.add(new GenericInjector.ClassInfo.Builder().path(target.path).instrumentedBy(method).owner(target.ownerObject).method(method).signature(signature).instrumentation(target.getTypes()).exceptionToCatch(target.exceptionToCatch).feature(interceptor.feature).classesToInject(target.classesToInject).build());
            }
        }
        return list;
    }

    private static class Interceptor {
        public String feature;
        public String info;
        public Target[] targets;

        private Interceptor() {
        }

        public static Interceptor load(InputStream input) {
            Constructor objConstructor = new Constructor(Interceptor.class);
            Yaml yaml = new Yaml(objConstructor);
            return (Interceptor)yaml.load(input);
        }
    }

    private static class Target {
        public String ownerObject;
        public String path;
        public List<String> classesToInject;
        public String exceptionToCatch;
        public List<String> instrumentation;
        public Map<String, String> methods;

        private Target() {
        }

        public EnumSet<GenericInjector.InstrumentationTypes> getTypes() {
            EnumSet<GenericInjector.InstrumentationTypes> instTypes = EnumSet.noneOf(GenericInjector.InstrumentationTypes.class);
            for (String inst : this.instrumentation) {
                if (inst.equalsIgnoreCase("entry")) {
                    instTypes.add(GenericInjector.InstrumentationTypes.Entry);
                    continue;
                }
                if (inst.equalsIgnoreCase("exit")) {
                    instTypes.add(GenericInjector.InstrumentationTypes.Exit);
                    continue;
                }
                if (inst.equalsIgnoreCase("replace")) {
                    instTypes.add(GenericInjector.InstrumentationTypes.Replace);
                    continue;
                }
                if (inst.equalsIgnoreCase("wrapLastArg")) {
                    instTypes.add(GenericInjector.InstrumentationTypes.WrapLastArg);
                    continue;
                }
                throw new RuntimeException("Unknown instrumentation type: " + inst);
            }
            return instTypes;
        }

        public String toString() {
            return "Target={" + String.format("path=%s,", this.path) + String.format("classesToInject=%s,", this.classesToInject != null ? this.classesToInject.toString() : null) + String.format("ownerObject=%s,", this.ownerObject) + String.format("exceptionToCatch=%s,", this.exceptionToCatch) + String.format("instrumentation=%s,", this.instrumentation.toString()) + String.format("methods=%s}", this.methods.toString());
        }
    }
}

