/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.adapters;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.HashSet;

public class JSInjectionAdapter
extends BaseClassVisitor {
    private final ClassUtil classUtil;
    private final String className;
    private final HashSet<String> methods;
    private boolean isTargetClass = false;

    public JSInjectionAdapter(ClassVisitor cv, ClassUtil classUtil, String className, String[] methods) {
        super(cv);
        this.classUtil = classUtil;
        this.className = className;
        this.methods = new HashSet();
        for (String methodString : methods) {
            Method method = Method.getMethod(methodString);
            this.methods.add(method.getName() + method.getDescriptor());
        }
    }

    private boolean shouldInstrumentMethod(String methodName, String methodDesc) {
        return this.methods.contains(methodName + methodDesc);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        boolean bl = this.isTargetClass = !name.startsWith("android/") && superName.startsWith("android/") && this.classUtil.getCommonSuperClass(this.className, name).equals(this.className);
        if (this.isTargetClass) {
            this.logger.debug("Found a descendant of %s class: %s", this.className, this.className);
            BCIRunSummary.getDefaultInstance().featureInjected("JS_INJECTION", this.className);
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        if (this.isTargetClass && this.shouldInstrumentMethod(methodName, methodDesc)) {
            this.logger.debug("Instrumenting method: %s%s", methodName, methodDesc);
            return new BaseClassVisitor.BaseMethodVisitor(baseMV, access, methodName, methodDesc){

                @Override
                public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                    if (JSInjectionAdapter.this.shouldInstrumentMethod(name, desc)) {
                        Method method = new Method(name, desc);
                        Type ownerType = Type.getObjectType(owner);
                        JSInjectionAdapter.this.logger.debug("Instrumenting method: %s%s", this.methodName, this.methodDesc);
                        int ownerLocal = this.dupOwnerOnly(ownerType, method);
                        this.pop();
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                        this.loadLocal(ownerLocal);
                        this.loadArg(0);
                        this.mv.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "injectJSAgent", "(Landroid/webkit/WebView;)V", false);
                    } else {
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }
                }
            };
        }
        return baseMV;
    }

    public static class Factory
    implements IAdapterFactory {
        private final ClassUtil classUtil;

        public Factory(ClassUtil classUtil) {
            this.classUtil = classUtil;
        }

        @Override
        public ClassVisitor createAdapter(ClassVisitor delegate) {
            String className = "android/webkit/WebViewClient";
            String[] methods = new String[]{"void onPageFinished(android.webkit.WebView, String)"};
            return new JSInjectionAdapter(delegate, this.classUtil, className, methods);
        }
    }
}

