/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.adapters;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.HashSet;

public class AddJSCallbackAdapter
extends BaseClassVisitor {
    private final ClassUtil classUtil;
    private final String className;
    private final HashSet<String> methods;

    public AddJSCallbackAdapter(ClassVisitor cv, ClassUtil classUtil, String className, String[] methods) {
        super(cv);
        this.classUtil = classUtil;
        this.className = className;
        this.methods = new HashSet();
        for (String methodString : methods) {
            Method method = Method.getMethod(methodString);
            this.methods.add(method.getName() + method.getDescriptor());
        }
    }

    private boolean shouldInstrumentMethod(int opcode, String owner, String methodName, String methodDesc) {
        if (opcode == 182 && this.methods.contains(methodName + methodDesc)) {
            boolean hasCommonSuperClass;
            try {
                hasCommonSuperClass = this.className.equals(this.classUtil.getCommonSuperClass(this.className, owner));
            }
            catch (RuntimeException e) {
                BCILogger.getBciLogger().warn("Unable to find common super class. owner: %s, matcher: %s. Exception: ", owner, this.className, e);
                hasCommonSuperClass = false;
            }
            return hasCommonSuperClass;
        }
        return false;
    }

    @Override
    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        MethodVisitor baseMV = super.visitMethod(access, methodName, methodDesc, signature, exceptions);
        return new BaseClassVisitor.BaseMethodVisitor(baseMV, access, methodName, methodDesc){

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (AddJSCallbackAdapter.this.shouldInstrumentMethod(opcode, owner, name, desc)) {
                    Method method = new Method(name, desc);
                    Type ownerType = Type.getObjectType(owner);
                    AddJSCallbackAdapter.this.logger.debug("Instrumenting method: %s%s", this.methodName, this.methodDesc);
                    this.dupOwnerOnly(ownerType, method);
                    this.mv.visitMethodInsn(184, "com/appdynamics/eumagent/runtime/InstrumentationCallbacks", "setupJSCallback", "(Landroid/webkit/WebView;)V", false);
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc, itf);
                }
            }
        };
    }

    public static class Factory
    implements IAdapterFactory {
        private final ClassUtil classUtil;

        public Factory(ClassUtil classUtil) {
            this.classUtil = classUtil;
        }

        @Override
        public ClassVisitor createAdapter(ClassVisitor delegate) {
            String className = "android/webkit/WebView";
            String[] methods = new String[]{"void loadUrl(String)", "void loadUrl(String, java.util.Map)", "void loadDataWithBaseURL(String, String, String, String, String)"};
            return new AddJSCallbackAdapter(delegate, this.classUtil, className, methods);
        }
    }
}

