/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.configs;

import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.List;

public class MethodCallMatcher {
    public final String clazz;
    public final Method method;
    public final boolean matchSubclasses;
    public final int opcode;
    public final ClassUtil classUtil;
    public final List<String> excludedPackagePrefixes;

    public MethodCallMatcher(String clazz, String method, boolean matchSubclasses, int opcode, ClassUtil classUtil, List<String> excludedPackagePrefixes) {
        this.clazz = clazz;
        this.matchSubclasses = matchSubclasses;
        this.method = Method.getMethod(method.replace('/', '.'));
        this.opcode = opcode;
        this.classUtil = classUtil;
        this.excludedPackagePrefixes = excludedPackagePrefixes;
    }

    public boolean isMethodCallMatched(int opcode, String owner, String methodName, String methodDesc) {
        if (opcode == 182 && this.method.getName().equals(methodName) && this.method.getDescriptor().equals(methodDesc)) {
            boolean hasCommonSuperClass;
            if (this.matchSubclasses) {
                try {
                    hasCommonSuperClass = this.clazz.equals(this.classUtil.getCommonSuperClass(this.clazz, owner));
                }
                catch (RuntimeException e) {
                    BCILogger.getBciLogger().warn("Unable to find common super class. owner: %s, matcher: %s. Exception: ", owner, this.clazz, e);
                    hasCommonSuperClass = false;
                }
            } else {
                hasCommonSuperClass = owner.equals(this.clazz);
            }
            return hasCommonSuperClass;
        }
        return false;
    }

    public boolean isTargetClass(String aClazz) {
        if (this.excludedPackagePrefixes == null || this.excludedPackagePrefixes.isEmpty()) {
            return true;
        }
        for (String excludedPackage : this.excludedPackagePrefixes) {
            if (!aClazz.startsWith(excludedPackage)) continue;
            return false;
        }
        return true;
    }
}

