/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.util;

import com.appdynamics.android.bci.io.IStreamFactory;
import com.appdynamics.android.logging.BCILogger;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class BuildUtils {
    public static IStreamFactory getStreamFactory() {
        return new IStreamFactory(){

            @Override
            public InputStream getInputStream(File f) throws IOException {
                return new FileInputStream(f);
            }

            @Override
            public OutputStream getOutputStream(File f) throws IOException {
                return new FileOutputStream(f);
            }

            @Override
            public JarInputStream getJarInputStream(InputStream is) throws IOException {
                return new JarInputStream(is);
            }

            @Override
            public JarOutputStream getJarOutputStream(OutputStream os, Manifest manifest) throws IOException {
                if (manifest == null) {
                    return new JarOutputStream(os);
                }
                return new JarOutputStream(os, manifest);
            }
        };
    }

    public static void prepareOutputDirectory(File outputDir) throws Exception {
        if (outputDir.exists()) {
            File[] existingFiles = outputDir.listFiles();
            if (existingFiles != null) {
                for (File f : existingFiles) {
                    BuildUtils.recursivelyDelete(f);
                }
            }
        } else if (!outputDir.mkdirs()) {
            throw new Exception("Unable to create output directory: " + outputDir.getAbsoluteFile());
        }
    }

    private static void recursivelyDelete(File toDelete) throws Exception {
        File[] contents;
        if (toDelete.isDirectory() && (contents = toDelete.listFiles()) != null) {
            for (File f : contents) {
                BuildUtils.recursivelyDelete(f);
            }
        }
        if (!toDelete.delete()) {
            throw new Exception("Unable to delete file in output directory: " + toDelete.getAbsoluteFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File dest, File src) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(dest).getChannel();
            long bytesToCopy = source.size();
            for (long bytesCopied = 0L; bytesCopied < bytesToCopy; bytesCopied += ((FileChannel)destination).transferFrom(source, 0L, source.size())) {
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static ByteArrayOutputStream copyStream(InputStream inputStream) throws IOException {
        int count;
        byte[] tempBuffer = new byte[4096];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        while ((count = inputStream.read(tempBuffer)) != -1) {
            outputStream.write(tempBuffer, 0, count);
        }
        return outputStream;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String encloseInBanner(String stringToEnclose, char bannerChar) {
        StringBuilder bldr = new StringBuilder();
        String s = bannerChar + "";
        bldr.append("/").append(BuildUtils.repeat(s, stringToEnclose.length() + 2)).append("\\\n").append("| ").append(stringToEnclose).append(" |\n").append("\\").append(BuildUtils.repeat(s, stringToEnclose.length() + 2)).append("/\n");
        return bldr.toString();
    }

    public static String encloseInBanner(String s) {
        return BuildUtils.encloseInBanner(s, '*');
    }

    public static String repeat(String s, int times) {
        StringBuilder bldr = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            bldr.append(s);
        }
        return bldr.toString();
    }

    public static void printInstrumentationStarting() {
        BCILogger.getBciLogger().info("\n\n\t\t\t%s\n\n", BuildUtils.encloseInBanner("Starting AppDynamics BCI Instrumentation", '=').replaceAll("\n", "\n\t\t\t"));
    }
}

