/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.util;

import com.appdynamics.android.bci.util.ClassInfo;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.asm.ClassReader;
import com.appdynamics.repackaged.asm.ClassVisitor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class TypeHierarchy {
    private final Map<String, ClassInfo> classMap = new HashMap<String, ClassInfo>();
    private final URLClassLoader urlClassLoader;

    public TypeHierarchy(URLClassLoader urlClassLoader) {
        this.urlClassLoader = urlClassLoader;
        this.classMap.put("java.lang.Object", ClassInfo.JAVA_LANG_OBJECT);
    }

    public ClassInfo getClassInfo(String name) throws ClassNotFoundException, IOException {
        if (!this.classMap.containsKey(name = this.toJavaStyle(name))) {
            this.loadClazz(name);
        }
        return this.classMap.get(name);
    }

    private void loadClazz(String name) throws ClassNotFoundException, IOException {
        URL url = this.urlClassLoader.findResource(name.replace(".", "/") + ".class");
        if (url == null) {
            throw new ClassNotFoundException(name + " not found!");
        }
        if (this.classMap.containsKey(name)) {
            return;
        }
        ClassReader reader = new ClassReader(this.readContents(url));
        reader.accept(new ClassVisitor(327680){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                try {
                    super.visit(version, access, name, signature, superName, interfaces);
                    ClassInfo superClass = null;
                    if (superName != null) {
                        superClass = TypeHierarchy.this.getClassInfo(TypeHierarchy.this.toJavaStyle(superName));
                    }
                    HashSet<ClassInfo> interfaceSet = new HashSet<ClassInfo>();
                    for (String implementedInterface : interfaces) {
                        interfaceSet.add(TypeHierarchy.this.getClassInfo(TypeHierarchy.this.toJavaStyle(implementedInterface)));
                    }
                    String javaName = TypeHierarchy.this.toJavaStyle(name);
                    TypeHierarchy.this.classMap.put(javaName, new ClassInfo(javaName, superClass, interfaceSet, (access & 0x200) != 0));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, 7);
    }

    private String toJavaStyle(String name) {
        return name.replace("/", ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readContents(URL url) throws IOException {
        byte[] byArray;
        block4: {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedInputStream in = null;
            try {
                int read;
                in = new BufferedInputStream(url.openConnection().getInputStream());
                byte[] buffer = new byte[4096];
                while ((read = in.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                byArray = out.toByteArray();
                if (in == null) break block4;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    BuildUtils.closeQuietly(in);
                }
                throw throwable;
            }
            BuildUtils.closeQuietly(in);
        }
        return byArray;
    }
}

