/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.io;

import com.appdynamics.android.StopInstrumentationException;
import com.appdynamics.android.bci.ClassStreamRewriter;
import com.appdynamics.android.bci.io.IStreamFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ClassFileRewriter {
    private final File root;
    private final ClassStreamRewriter rewriter;
    private final IStreamFactory streamFactory;

    public ClassFileRewriter(File root, ClassStreamRewriter rewriter, IStreamFactory streamFactory) {
        this.root = root;
        this.rewriter = rewriter;
        this.streamFactory = streamFactory;
    }

    public void rewrite() throws IOException {
        this.rewriter.beginInstrumentationOfClassContainer(this.root);
        try {
            this.rewrite(this.root);
        }
        finally {
            this.rewriter.endInstrumentationOfClassContainer(this.root);
        }
    }

    private void rewrite(File file) throws IOException {
        if (file.isFile() && file.getName().endsWith(".class")) {
            InputStream is = null;
            OutputStream os = null;
            try {
                is = this.streamFactory.getInputStream(file);
                this.rewriter.readInput(is);
                os = this.streamFactory.getOutputStream(file);
                this.rewriter.writeOutput(os);
            }
            catch (StopInstrumentationException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new IOException("Unexpected error performing byte code injection on file " + file.getAbsoluteFile(), e);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        } else if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                this.rewrite(f);
            }
        }
    }
}

