/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

public abstract class BCILogger {
    private static BCILogger bciLogger;

    public static void setBciLogger(BCILogger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("BCILogger cannot be null!");
        }
        if (bciLogger != null) {
            throw new IllegalStateException("BCILogger already set to: " + logger);
        }
        bciLogger = logger;
    }

    public static boolean isInitialized() {
        if (bciLogger == null) {
            return false;
        }
        if (bciLogger.exists()) {
            return true;
        }
        bciLogger = null;
        return false;
    }

    public static BCILogger getBciLogger() {
        if (bciLogger == null) {
            throw new IllegalStateException("BCILogger isn't initialized yet!");
        }
        return bciLogger;
    }

    protected boolean exists() {
        return true;
    }

    public static BCILogger getLoggerFor(final Class<?> clazz) {
        return new BCILogger(){

            @Override
            protected void log(Level level, String msg) {
                BCILogger.getBciLogger().log(level, " <" + clazz.getSimpleName() + "> " + msg);
            }

            @Override
            public void error(Throwable th, String msg) {
                BCILogger.getBciLogger().error(th, " <" + clazz.getSimpleName() + "> " + msg);
            }
        };
    }

    private void log(Level level, String msg, Object ... args) {
        if (args == null || args.length == 0) {
            this.log(level, msg);
        } else {
            this.log(level, String.format(msg, args));
        }
    }

    public void error(Throwable th, String msg, Object ... args) {
        if (args == null || args.length == 0) {
            this.error(th, msg);
        } else {
            this.error(th, String.format(msg, args));
        }
    }

    protected abstract void log(Level var1, String var2);

    public abstract void error(Throwable var1, String var2);

    public void trace(String msg, Object ... args) {
        this.log(Level.TRACE, msg, args);
    }

    public void debug(String msg, Object ... args) {
        this.log(Level.DEBUG, msg, args);
    }

    public void info(String msg, Object ... args) {
        this.log(Level.INFO, msg, args);
    }

    public void warn(String msg, Object ... args) {
        this.log(Level.WARN, msg, args);
    }

    public void error(String msg, Object ... args) {
        this.log(Level.ERROR, msg, args);
    }

    public void close() {
        if (bciLogger == null) {
            return;
        }
        bciLogger.close();
        bciLogger = null;
    }

    public static abstract class MultiLogger
    extends BCILogger {
        private final File logFile;
        private final PrintStream printStream;

        protected MultiLogger(File logDir) throws FileNotFoundException {
            if (logDir == null || !logDir.isDirectory()) {
                throw new IllegalArgumentException("logFile: [" + logDir + "] cannot be null. Need a valid directory!");
            }
            this.logFile = new File(logDir, "appdynamics_eum_android_bci.log");
            this.printStream = new PrintStream(this.logFile);
        }

        @Override
        protected final boolean exists() {
            if (!this.logFile.exists()) {
                this.printStream.close();
                return false;
            }
            return true;
        }

        @Override
        public final void close() {
            this.printStream.close();
        }

        @Override
        public final void log(Level level, String msg) {
            this.printStream.append(msg + "\n");
            this._log(level, msg);
        }

        protected abstract void _log(Level var1, String var2);

        @Override
        public final void error(Throwable th, String msg) {
            this.printStream.append("[ERROR] " + msg);
            th.printStackTrace(this.printStream);
            this.printStream.append("\n");
        }
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

