/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ActivityLifecycleAdapter
extends BaseClassVisitor {
    private static final String ACTIVITY_CLASS_NAME = "android/app/Activity";
    private static final String INSTRUMENTATION_CLASS_NAME = "com/appdynamics/eumagent/runtime/InstrumentationCallbacks";
    private final BCIRunSummary bciSummary = BCIRunSummary.getDefaultInstance();
    private boolean isActivityClass;
    private EnumSet<Lifecycle> methodPresent;
    private final ClassUtil classUtil;
    private String superName;
    private static final String VOID_RETURN_NO_PARAM = "()V";
    private static final String ACTIVITY_CALL_DESC = "(Landroid/app/Activity;)V";
    private static final Map<String, Lifecycle> LIFECYCLE_MAP = new HashMap<String, Lifecycle>(Lifecycle.values().length);

    public ActivityLifecycleAdapter(ClassVisitor classVisitor, ClassUtil classUtil) {
        super(classVisitor);
        this.classUtil = classUtil;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        boolean bl = this.isActivityClass = !name.startsWith("android/") && superName.startsWith("android/") && this.classUtil.getCommonSuperClass(ACTIVITY_CLASS_NAME, name).equals(ACTIVITY_CLASS_NAME);
        if (this.isActivityClass) {
            this.logInjectedWithLineNumber("Found a descendant of android.app.Activity class: %s", this.className);
            this.methodPresent = EnumSet.noneOf(Lifecycle.class);
            this.superName = superName;
        }
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Lifecycle lifecycle;
        MethodVisitor nextVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        if (nextVisitor != null && this.isActivityClass && (lifecycle = LIFECYCLE_MAP.get(name)) != null && lifecycle.methodDesc.equals(desc)) {
            this.bciSummary.featureInjected("ANR", this.className);
            this.methodPresent.add(lifecycle);
            return new ActivityMethodVisitor(access, name, nextVisitor, desc, lifecycle);
        }
        return new BaseClassVisitor.BaseMethodVisitor(this, nextVisitor, access, name, desc);
    }

    @Override
    public void visitEnd() {
        EnumSet<Lifecycle> methodsNotImplemented;
        if (this.isActivityClass && !(methodsNotImplemented = EnumSet.complementOf(this.methodPresent)).isEmpty()) {
            this.bciSummary.featureInjected("ANR", this.className);
            for (Lifecycle toAdd : methodsNotImplemented) {
                MethodVisitor mv = super.visitMethod(4, toAdd.methodName, toAdd.methodDesc, null, null);
                mv.visitCode();
                mv.visitVarInsn(25, 0);
                if (toAdd == Lifecycle.ON_CREATE) {
                    mv.visitVarInsn(25, 1);
                }
                mv.visitMethodInsn(183, this.superName, toAdd.methodName, toAdd.methodDesc);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(184, INSTRUMENTATION_CLASS_NAME, toAdd.instrumentationMethodName, ACTIVITY_CALL_DESC);
                mv.visitInsn(177);
                mv.visitEnd();
                this.logInjectedWithLineNumber("Finished injecting method: %s into class %s", toAdd.methodName, this.className);
            }
        }
        super.visitEnd();
    }

    static {
        for (Lifecycle lifecycle : Lifecycle.values()) {
            LIFECYCLE_MAP.put(lifecycle.methodName, lifecycle);
        }
    }

    public static enum Lifecycle {
        ON_CREATE("onCreate", "(Landroid/os/Bundle;)V"),
        ON_START("onStart", "()V"),
        ON_RESTART("onRestart", "()V"),
        ON_RESUME("onResume", "()V"),
        ON_PAUSE("onPause", "()V"),
        ON_STOP("onStop", "()V"),
        ON_DESTROY("onDestroy", "()V");

        public final String methodName;
        public final String methodDesc;
        public final String instrumentationMethodName;

        private Lifecycle(String methodName, String methodDesc) {
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.instrumentationMethodName = methodName + "Called";
        }
    }

    public static class Factory
    implements IAdapterFactory {
        private final ClassUtil classUtil;

        public Factory(ClassUtil classUtil) {
            this.classUtil = classUtil;
        }

        @Override
        public ClassVisitor createAdapter(ClassVisitor delegate) {
            return new ActivityLifecycleAdapter(delegate, this.classUtil);
        }
    }

    private class ActivityMethodVisitor
    extends BaseClassVisitor.BaseMethodVisitor {
        final Lifecycle lifecycle;

        public ActivityMethodVisitor(int access, String name, MethodVisitor methodVisitor, String desc, Lifecycle lifecycle) {
            super(ActivityLifecycleAdapter.this, methodVisitor, access, name, desc);
            this.lifecycle = lifecycle;
        }

        @Override
        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, ActivityLifecycleAdapter.INSTRUMENTATION_CLASS_NAME, this.lifecycle.instrumentationMethodName, ActivityLifecycleAdapter.ACTIVITY_CALL_DESC);
            ActivityLifecycleAdapter.this.logInjectedWithOnlySourceInfo("Finished injecting call to %s.%s at %s.%s", ActivityLifecycleAdapter.INSTRUMENTATION_CLASS_NAME, this.lifecycle.instrumentationMethodName, ActivityLifecycleAdapter.this.className, this.methodName);
        }
    }
}

