/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.logging.BCIRunSummary;
import com.appdynamics.repackaged.asm.AnnotationVisitor;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ManualInfoPointAdapter
extends BaseClassVisitor {
    private static final String infoPointAnnotation = "Lcom/appdynamics/eumagent/runtime/InfoPoint;";
    public static final Type instrumentationClass = Type.getObjectType("com/appdynamics/eumagent/runtime/Instrumentation");
    private static final Type trackerType = Type.getType("Lcom/appdynamics/eumagent/runtime/CallTracker;");
    private static final Method endCallMethod = Method.getMethod("void endCall(com.appdynamics.eumagent.runtime.CallTracker, Object)");
    private static final Method beginCallMethod = Method.getMethod("com.appdynamics.eumagent.runtime.CallTracker beginCall(boolean, String, String, Object[])");
    private static final Set<String> twoWordsReturnType = new HashSet<String>(Arrays.asList("double", "long"));

    public ManualInfoPointAdapter(ClassVisitor classVisitor) {
        super(classVisitor);
    }

    @Override
    public MethodVisitor visitMethod(final int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        return new BaseClassVisitor.BaseMethodVisitor(super.visitMethod(access, methodName, methodDesc, signature, exceptions), access, methodName, methodDesc){
            private Label tryLabel;
            private Label endLabel;
            private int trackerRef;
            private boolean interested;
            {
                super(x0, x1, x2, x3);
                this.trackerRef = -1;
                this.interested = false;
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                this.interested = ManualInfoPointAdapter.infoPointAnnotation.equals(desc);
                if (this.interested) {
                    BCIRunSummary.getDefaultInstance().featureInjected(BCIRunSummary.Feature.INFO_POINT, ManualInfoPointAdapter.this.className);
                    ManualInfoPointAdapter.this.logInjectedWithLineNumber("%s.%s is annotated with @InfoPoint. Infopoint calls will be injected into this method.", ManualInfoPointAdapter.this.className, this.methodName);
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public void visitCode() {
                super.visitCode();
                if (this.interested) {
                    this.trackerRef = this.newLocal(trackerType);
                    this.push((access & 8) != 0);
                    this.push(ManualInfoPointAdapter.this.className);
                    this.push(this.methodName);
                    this.loadArgArray();
                    this.invokeStatic(instrumentationClass, beginCallMethod);
                    this.storeLocal(this.trackerRef);
                    this.tryLabel = new Label();
                    this.endLabel = new Label();
                    this.mv.visitTryCatchBlock(this.tryLabel, this.endLabel, this.endLabel, null);
                    this.mv.visitLabel(this.tryLabel);
                    ManualInfoPointAdapter.this.logInjectedWithLineNumber("Injected: %s.%s at the beginning of %s.%s", instrumentationClass.getClassName(), beginCallMethod.getName(), ManualInfoPointAdapter.this.className, this.methodName);
                }
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                if (this.interested) {
                    this.mv.visitLabel(this.endLabel);
                    this.handleFinally(false);
                    this.mv.visitInsn(191);
                }
                super.visitMaxs(maxStack, maxLocals);
            }

            @Override
            protected void onMethodExit(int opcode) {
                if (this.interested && opcode != 191) {
                    this.handleFinally(true);
                }
            }

            private void handleFinally(boolean returning) {
                if (this.interested) {
                    Type returnType = Type.getReturnType(this.methodDesc);
                    if (!returning || Type.VOID_TYPE.equals(returnType.getReturnType())) {
                        this.loadLocal(this.trackerRef);
                        this.push((String)null);
                    } else {
                        if (twoWordsReturnType.contains(returnType.getReturnType().getClassName())) {
                            this.dup2();
                        } else {
                            this.dup();
                        }
                        this.box(returnType);
                        this.loadLocal(this.trackerRef);
                        this.swap(Type.getType(Object.class), trackerType);
                    }
                    ManualInfoPointAdapter.this.logInjectedWithLineNumber("Injected: %s.%s at the end of %s.%s", instrumentationClass.getClassName(), endCallMethod.getName(), ManualInfoPointAdapter.this.className, this.methodName);
                    this.invokeStatic(instrumentationClass, endCallMethod);
                }
            }
        };
    }

    public static class Factory
    implements IAdapterFactory {
        @Override
        public ClassVisitor createAdapter(ClassVisitor delegate) {
            return new ManualInfoPointAdapter(delegate);
        }
    }
}

