/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci.infop;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.ClassUtil;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.android.bci.infop.MasterFlagGenerator;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Opcodes;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.Method;
import com.appdynamics.repackaged.asm.tree.MethodNode;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class ConstructorInvokeReplacer
implements IAdapterFactory,
Opcodes {
    private static final Type INFOPOINT_REGISTER_TYPE = Type.getObjectType("com/appdynamics/eumagent/runtime/InfoPointRegister");
    private final MasterFlagGenerator generator = new MasterFlagGenerator();
    private final ClassUtil classUtil;
    private boolean enabled = false;
    private boolean debug = false;
    private static final Set<String> EXCLUDED_PACKAGES = new HashSet<String>(Arrays.asList("android/", "java/", "javax/", "junit/", "org/apache", "org/json", "org/w3c", "org/xml", "com/appdynamics/android", "com/appdynamics/eumagent"));

    public ConstructorInvokeReplacer(ClassUtil classUtil) {
        this.classUtil = classUtil;
    }

    @Override
    public ClassVisitor createAdapter(ClassVisitor delegate) {
        return new Visitor(delegate);
    }

    private boolean isIncluded(String type) {
        for (String excluded : EXCLUDED_PACKAGES) {
            if (!type.startsWith(excluded)) continue;
            return false;
        }
        return true;
    }

    public static String getGeneratedSubclassTypeName(String originalType) {
        return originalType + "_ADEumGenerated";
    }

    MasterFlagGenerator getGenerator() {
        return this.generator;
    }

    public byte[] generateInfoPointRegister(File outputFile) throws IOException {
        return this.generator.writeMasterFlagsClassInto(outputFile);
    }

    public String getInfoPointRegisterClassName() {
        return "com/appdynamics/eumagent/runtime/InfoPointRegister".replaceAll("/", ".");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private class InstanceCreationPeeker
    extends MethodVisitor {
        final BCILogger logger;
        final BitSet interceptCreations;
        private int newCount;
        private final Stack<InstanceTracker> newObjects;

        public InstanceCreationPeeker() {
            super(262144, null);
            this.logger = BCILogger.getLoggerFor(this.getClass());
            this.interceptCreations = new BitSet();
            this.newCount = 0;
            this.newObjects = new Stack();
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 183 && "<init>".equals(name) && !this.newObjects.isEmpty() && owner.equals(this.newObjects.peek().type)) {
                InstanceTracker tracker = this.newObjects.pop();
                if (this.isInterceptable(tracker.type, desc)) {
                    this.interceptCreations.set(tracker.count);
                    ConstructorInvokeReplacer.this.generator.addToInterceptedList(tracker.type);
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 187) {
                ++this.newCount;
                if (ConstructorInvokeReplacer.this.isIncluded(type)) {
                    this.newObjects.push(new InstanceTracker(type, this.newCount));
                }
            }
            super.visitTypeInsn(opcode, type);
        }

        private boolean isInterceptable(String type, String constructorArgs) {
            ArrayList<Type> args = new ArrayList<Type>();
            for (Type arg : Type.getArgumentTypes(constructorArgs)) {
                args.add(arg);
            }
            String className = Type.getObjectType(type).getClassName();
            try {
                ClassUtil.ConstructorInfo info = ConstructorInvokeReplacer.this.classUtil.getInformationAboutClass(className, args);
                return !info.finalOrAnonymous() && info.isClassAndConstructorPublic() && info.ifNestedIsClassStatic();
            }
            catch (Exception e) {
                this.logger.error(e, "Error while processing class: %s, constructor = %s", className, constructorArgs);
                return false;
            }
        }

        class InstanceTracker {
            final String type;
            final int count;

            InstanceTracker(String type, int count) {
                this.type = type;
                this.count = count;
            }
        }
    }

    private class Visitor
    extends BaseClassVisitor {
        public Visitor(ClassVisitor cv) {
            super(cv);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            final MethodVisitor oldVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (!ConstructorInvokeReplacer.this.isEnabled()) {
                return oldVisitor;
            }
            return new MethodNode(access, name, desc, signature, exceptions){

                @Override
                public void visitEnd() {
                    super.visitEnd();
                    InstanceCreationPeeker peeker = new InstanceCreationPeeker();
                    super.accept(peeker);
                    if (peeker.interceptCreations.cardinality() == 0) {
                        this.accept(oldVisitor);
                    } else {
                        Visitor.this.logger.info("Inside method: %s.%s, we identified #%d dynamic info points", Visitor.this.className, this.name, peeker.interceptCreations.cardinality());
                        this.accept(new DynamicSubClassWeaver(this.access, this.name, this.desc, oldVisitor, peeker.interceptCreations));
                    }
                }
            };
        }

        private class DynamicSubClassWeaver
        extends BaseClassVisitor.BaseMethodVisitor {
            private int newCounter;
            private final BitSet interceptCreations;
            private final Stack<String> stack;
            private boolean deleteDup;

            protected DynamicSubClassWeaver(int access, String name, String desc, MethodVisitor mVisitor, BitSet interceptCreations) {
                super(mVisitor, access, name, desc);
                this.newCounter = 0;
                this.stack = new Stack();
                this.deleteDup = false;
                this.interceptCreations = interceptCreations;
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                if (opcode == 183 && "<init>".equals(name) && !this.stack.isEmpty() && owner.equals(this.stack.peek())) {
                    Type[] argTypes = Type.getArgumentTypes(desc);
                    int[] locals = new int[argTypes.length];
                    for (int i = argTypes.length - 1; i >= 0; --i) {
                        locals[i] = this.newLocal(argTypes[i]);
                        this.storeLocal(locals[i], argTypes[i]);
                    }
                    String className = Type.getObjectType(owner).getClassName();
                    String booleanFieldName = ConstructorInvokeReplacer.this.generator.toFieldName(className);
                    String subTypeClassName = ConstructorInvokeReplacer.getGeneratedSubclassTypeName(className);
                    Labels labels = new Labels();
                    Visitor.this.logInjectedWithLineNumber("Injecting dynamic info point here. Replaced with type: %s", new Object[]{subTypeClassName});
                    this.getStatic(INFOPOINT_REGISTER_TYPE, booleanFieldName, Type.BOOLEAN_TYPE);
                    this.ifZCmp(153, labels.originalNewIns);
                    this.generateDebugPrintIns("Since boolean flag is enabled, trying to instantiate subclass: " + subTypeClassName);
                    this.generateCreateObjectUsingReflection(subTypeClassName, desc, locals, labels, className);
                    this.goTo(labels.afterOriginalNewIns);
                    this.visitLabel(labels.bailout);
                    this.pop();
                    this.visitLabel(labels.originalNewIns);
                    this.generateCreateObject(owner, desc, locals);
                    this.generateDebugPrintIns("After running normal create routine.");
                    this.visitLabel(labels.afterOriginalNewIns);
                    this.stack.pop();
                } else {
                    super.visitMethodInsn(opcode, owner, name, desc);
                }
            }

            private void generateDebugPrintIns(String content) {
                if (ConstructorInvokeReplacer.this.debug) {
                    this.getStatic(Type.getType(System.class), "out", Type.getType(PrintStream.class));
                    this.dup();
                    this.push(content);
                    this.invokeVirtual(Type.getType(PrintStream.class), Method.getMethod("void println(String)"));
                    this.invokeVirtual(Type.getType(PrintStream.class), Method.getMethod("void flush()"));
                }
            }

            private void generateCreateObjectUsingReflection(String subtypeClazzName, String desc, int[] args, Labels labels, String className) {
                this.generateDebugPrintIns("Trying to load the subclass:" + subtypeClazzName + " dynamically instead of the original object.");
                this.push(subtypeClazzName);
                Type[] constructorArgTypes = Type.getArgumentTypes(desc);
                this.push(constructorArgTypes.length);
                Type classType = Type.getObjectType("java/lang/Class");
                this.newArray(classType);
                for (int i = 0; i < constructorArgTypes.length; ++i) {
                    this.dup();
                    this.push(i);
                    this.push(constructorArgTypes[i]);
                    this.arrayStore(classType);
                }
                Type objectType = Type.getType(Object.class);
                this.push(args.length);
                super.newArray(objectType);
                for (int i = 0; i < args.length; ++i) {
                    this.dup();
                    this.push(i);
                    Type argType = constructorArgTypes[i];
                    this.loadLocal(args[i]);
                    this.box(argType);
                    this.arrayStore(objectType);
                }
                this.invokeStatic(BaseClassVisitor.CALLBACK_CLASS_TYPE, Method.getMethod("Object instantiate(String, Class[], Object[])"));
                this.dup();
                this.ifNull(labels.bailout);
                Type normalClass = Type.getObjectType(className.replaceAll("\\.", "/"));
                this.visitTypeInsn(192, normalClass.getInternalName());
                this.goTo(labels.afterOriginalNewIns);
                this.generateDebugPrintIns("After using reflection methods....");
            }

            private void generateCreateObject(String owner, String desc, int[] locals) {
                this.generateDebugPrintIns("Calling original constructor here.");
                super.visitTypeInsn(187, owner);
                super.visitInsn(89);
                for (int local : locals) {
                    this.loadLocal(local);
                }
                super.visitMethodInsn(183, owner, "<init>", desc);
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                if (opcode == 187 && this.interceptCreations.get(++this.newCounter)) {
                    this.deleteDup = true;
                    this.stack.push(type);
                } else {
                    super.visitTypeInsn(opcode, type);
                }
            }

            @Override
            public void visitInsn(int opcode) {
                if (opcode != 89 || !this.deleteDup) {
                    super.visitInsn(opcode);
                } else {
                    this.deleteDup = false;
                }
            }

            final class Labels {
                final Label originalNewIns = new Label();
                final Label afterOriginalNewIns = new Label();
                final Label bailout = new Label();

                Labels() {
                }
            }
        }
    }
}

