/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.bci.BaseClassVisitor;
import com.appdynamics.android.bci.IAdapterFactory;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.MethodVisitor;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NetworkConnectionHarvestMarker
extends BaseClassVisitor {
    private static final String URL_CONNECTION = "java/net/URLConnection";
    public static final Method markReportable = Method.getMethod("void requestHarvestable(java.net.URLConnection)");
    private static final Map<String, Set<Method>> insertAfterMap = new HashMap<String, Set<Method>>();

    private static void add(String type, Method method) {
        Set<Method> methodSet = insertAfterMap.get(type);
        if (methodSet == null) {
            methodSet = new HashSet<Method>();
            insertAfterMap.put(type, methodSet);
        }
        methodSet.add(method);
    }

    public NetworkConnectionHarvestMarker(ClassVisitor cv) {
        super(cv);
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
        MethodVisitor oldVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new BaseClassVisitor.BaseMethodVisitor(oldVisitor, access, name, desc){

            @Override
            public void visitMethodInsn(int opcode, String owner, String methodName, String desc) {
                Set methodSet = (Set)insertAfterMap.get(owner);
                if (opcode == 182 && methodSet != null && NetworkConnectionHarvestMarker.this.isPresent(methodName, desc, methodSet)) {
                    int i;
                    NetworkConnectionHarvestMarker.this.reportNetworkFeatureInjected(owner);
                    NetworkConnectionHarvestMarker.this.logInjectedWithLineNumber("Detected [%s.%s] reading response from network call inside %s.%s", owner, methodName, NetworkConnectionHarvestMarker.this.className, name);
                    Type[] argTypes = Type.getArgumentTypes(desc);
                    int ref = this.newLocal(Type.getType(owner));
                    int[] locals = new int[argTypes.length];
                    for (i = argTypes.length - 1; i >= 0; --i) {
                        locals[i] = this.newLocal(argTypes[i]);
                        this.storeLocal(locals[i], argTypes[i]);
                    }
                    this.dup();
                    this.storeLocal(ref);
                    for (i = 0; i < argTypes.length; ++i) {
                        this.loadLocal(locals[i], argTypes[i]);
                    }
                    super.visitMethodInsn(opcode, owner, methodName, desc);
                    this.loadLocal(ref);
                    this.invokeStatic(BaseClassVisitor.CALLBACK_CLASS_TYPE, markReportable);
                } else {
                    super.visitMethodInsn(opcode, owner, methodName, desc);
                }
            }
        };
    }

    private boolean isPresent(String methodName, String desc, Set<Method> methodSet) {
        for (Method m : methodSet) {
            if (!m.getName().equals(methodName) || !m.getDescriptor().equals(desc)) continue;
            return true;
        }
        return false;
    }

    static {
        String[] urlMethods = new String[]{"String getHeaderField(String)", "String getHeaderField(int)", "long getHeaderFieldDate(String,long)", "int getHeaderFieldInt(String,int)", "String getHeaderFieldKey(int)", "java.util.Map getHeaderFields()", "long getDate()", "String getContentType()", "int getContentLength()", "String getContentEncoding()", "Object getContent()", "long getLastModified()", "long getExpiration()"};
        HashSet<Method> commonUrlMethods = new HashSet<Method>();
        for (String urlMethod : urlMethods) {
            commonUrlMethods.add(Method.getMethod(urlMethod));
        }
        for (Method commonMethod : commonUrlMethods) {
            NetworkConnectionHarvestMarker.add(URL_CONNECTION, commonMethod);
            NetworkConnectionHarvestMarker.add("java/net/HttpURLConnection", commonMethod);
            NetworkConnectionHarvestMarker.add("javax/net/ssl/HttpsURLConnection", commonMethod);
        }
        NetworkConnectionHarvestMarker.add("java/net/HttpURLConnection", Method.getMethod("int getResponseCode()"));
        NetworkConnectionHarvestMarker.add("java/net/HttpURLConnection", Method.getMethod("String getResponseMessage()"));
        NetworkConnectionHarvestMarker.add("javax/net/ssl/HttpsURLConnection", Method.getMethod("int getResponseCode()"));
        NetworkConnectionHarvestMarker.add("javax/net/ssl/HttpsURLConnection", Method.getMethod("String getResponseMessage()"));
    }

    public static class Factory
    implements IAdapterFactory {
        @Override
        public ClassVisitor createAdapter(ClassVisitor delegate) {
            return new NetworkConnectionHarvestMarker(delegate);
        }
    }
}

