/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.android.bci;

import com.appdynamics.android.StopInstrumentationException;
import com.appdynamics.android.logging.BCILogger;
import com.appdynamics.android.util.BuildUtils;
import com.appdynamics.repackaged.asm.ClassVisitor;
import com.appdynamics.repackaged.asm.ClassWriter;
import com.appdynamics.repackaged.asm.FieldVisitor;
import com.appdynamics.repackaged.asm.Label;
import com.appdynamics.repackaged.asm.Opcodes;
import com.appdynamics.repackaged.asm.Type;
import com.appdynamics.repackaged.asm.commons.GeneratorAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BuildIdGenerator
implements Opcodes {
    private static final String CLAZZ_NAME = "com/appdynamics/eumagent/runtime/BuildInfo";
    public static final String buildFieldPrefix = "appdynamicsGeneratedBuildId_";
    private final BCILogger logger = BCILogger.getLoggerFor(BuildIdGenerator.class);
    private final MessageDigest md5Digest;
    private String computedId = null;

    public BuildIdGenerator() {
        try {
            this.md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error(e, "Unable to instantiate MD5 digester...", new Object[0]);
            throw new StopInstrumentationException("Cannot instantiate MD5 digester for computing build ids.");
        }
    }

    public void update(String className, byte[] classContents) {
        this.md5Digest.update(classContents);
    }

    public void generateBuildId() {
        if (this.computedId != null) {
            this.logger.debug("Id already generated. Ignoring call generateBuildId()", new Object[0]);
            return;
        }
        byte[] digest = this.md5Digest.digest();
        this.computedId = BuildIdGenerator.encodeHexString(digest);
        this.logger.debug("Finished computing build identifier. The current identifier is  = %s", this.computedId);
    }

    public String getId() {
        if (this.computedId == null) {
            throw new IllegalStateException("generateBuildId() must be called first!");
        }
        return this.computedId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeBuildInfoClass(File classesDirectory) throws IOException {
        this.generateBuildId();
        this.logger.info("Generating %s to store build ids at runtime.", CLAZZ_NAME);
        FileOutputStream out = null;
        try {
            ClassWriter writer = new ClassWriter(2);
            this.generateBuildInfoClass(writer);
            File file = new File(classesDirectory.getAbsolutePath() + File.separator + CLAZZ_NAME + ".class");
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Unable to create parent directory: " + file.getParentFile());
            }
            out = new FileOutputStream(file);
            out.write(writer.toByteArray());
            this.logger.info("Finished generating %s", CLAZZ_NAME);
            if (out == null) return;
        }
        catch (Exception ex) {
            try {
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                if (out == null) throw throwable;
                BuildUtils.closeQuietly(out);
                throw throwable;
            }
        }
        BuildUtils.closeQuietly(out);
        return;
    }

    private void generateBuildInfoClass(ClassWriter classVisitor) {
        classVisitor.visit(49, 4113, CLAZZ_NAME, null, "java/lang/Object", null);
        classVisitor.visitSource("BuildInfo.java", null);
        classVisitor.visitAnnotation("Lcom/appdynamics/eumagent/runtime/DontObfuscate;", false).visitEnd();
        this.addDefaultConstructor(classVisitor);
        String descriptor = Type.getType(Boolean.TYPE).getDescriptor();
        String fieldName = buildFieldPrefix + this.getId();
        FieldVisitor fv = classVisitor.visitField(4105, fieldName, descriptor, null, null);
        fv.visitEnd();
        classVisitor.visitEnd();
    }

    private void addDefaultConstructor(ClassVisitor classVisitor) {
        Label startConstructorLabel = new Label();
        Label endConstructorLabel = new Label();
        GeneratorAdapter mv = new GeneratorAdapter(classVisitor.visitMethod(1, "<init>", "()V", null, null), 1, "<init>", "()V");
        mv.visitLabel(startConstructorLabel);
        mv.visitIntInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitLabel(endConstructorLabel);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
    }

    public static String encodeHexString(byte[] data) {
        char[] toDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return new String(out);
    }
}

