/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.riemann;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.yammer.metrics.core.VirtualMachineMetrics;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class JvmMetricSet
implements MetricSet {
    private final String separator;
    private final VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();

    public JvmMetricSet() {
        this(" ");
    }

    public JvmMetricSet(String separator) {
        this.separator = separator;
    }

    private String service(String ... parts) {
        StringBuilder sb = new StringBuilder();
        for (String p : parts) {
            sb.append(p).append(this.separator);
        }
        return sb.substring(0, sb.length() - this.separator.length());
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        gauges.put(this.service("jvm", "memory", "heap-usage"), new Gauge<Double>(){

            public Double getValue() {
                return JvmMetricSet.this.vm.heapUsage();
            }
        });
        gauges.put(this.service("jvm", "memory", "non-heap-usage"), new Gauge<Double>(){

            public Double getValue() {
                return JvmMetricSet.this.vm.nonHeapUsage();
            }
        });
        gauges.put(this.service("jvm", "thread", "daemon-count"), new Gauge<Integer>(){

            public Integer getValue() {
                return JvmMetricSet.this.vm.daemonThreadCount();
            }
        });
        gauges.put(this.service("jvm", "thread", "count"), new Gauge<Integer>(){

            public Integer getValue() {
                return JvmMetricSet.this.vm.threadCount();
            }
        });
        gauges.put(this.service("jvm", "uptime"), new Gauge<Long>(){

            public Long getValue() {
                return JvmMetricSet.this.vm.uptime();
            }
        });
        gauges.put(this.service("jvm", "fd-usage"), new Gauge<Double>(){

            public Double getValue() {
                return JvmMetricSet.this.vm.fileDescriptorUsage();
            }
        });
        for (final Map.Entry pool : this.vm.memoryPoolUsage().entrySet()) {
            gauges.put(this.service("jvm", "memory", "pool-usage", (String)pool.getKey()), new Gauge<Double>(){

                public Double getValue() {
                    return (Double)pool.getValue();
                }
            });
        }
        for (final Map.Entry entry : this.vm.threadStatePercentages().entrySet()) {
            gauges.put(this.service("jvm", "thread", "state", ((Thread.State)((Object)entry.getKey())).toString().toLowerCase()), new Gauge<Double>(){

                public Double getValue() {
                    return (Double)entry.getValue();
                }
            });
        }
        for (final Map.Entry entry : this.vm.garbageCollectors().entrySet()) {
            gauges.put(this.service("jvm", "gc", (String)entry.getKey(), "time"), new Gauge<Long>(){

                public Long getValue() {
                    return ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getTime(TimeUnit.MILLISECONDS);
                }
            });
            gauges.put(this.service("jvm", "gc", (String)entry.getKey(), "runs"), new Gauge<Long>(){

                public Long getValue() {
                    return ((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getRuns();
                }
            });
        }
        return Collections.unmodifiableMap(gauges);
    }
}

