/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.client.IRiemannClient;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RiemannScheduler {
    public final ScheduledThreadPoolExecutor pool;
    public final IRiemannClient client;

    public RiemannScheduler(IRiemannClient client) {
        this(client, 1);
    }

    public RiemannScheduler(IRiemannClient client, int poolSize) {
        this.client = client;
        this.pool = new ScheduledThreadPoolExecutor(poolSize);
        this.pool.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.pool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    protected Runnable runnableCallback(final Task c) {
        return new Runnable(){

            @Override
            public void run() {
                c.run(RiemannScheduler.this.client);
            }
        };
    }

    public ScheduledFuture every(long interval, Runnable f) {
        return this.every(interval, 0L, f);
    }

    public ScheduledFuture every(long interval, Task c) {
        return this.every(interval, this.runnableCallback(c));
    }

    public ScheduledFuture every(long interval, TimeUnit unit, Runnable f) {
        return this.every(interval, 0L, unit, f);
    }

    public ScheduledFuture every(long interval, TimeUnit unit, Task c) {
        return this.every(interval, unit, this.runnableCallback(c));
    }

    public ScheduledFuture every(long interval, long delay, Runnable f) {
        return this.every(interval, delay, TimeUnit.MILLISECONDS, f);
    }

    public ScheduledFuture every(long interval, long delay, Task c) {
        return this.every(interval, delay, this.runnableCallback(c));
    }

    public ScheduledFuture every(long interval, long delay, TimeUnit unit, Runnable f) {
        return this.pool.scheduleAtFixedRate(f, delay, interval, unit);
    }

    public ScheduledFuture every(long interval, long delay, TimeUnit unit, Task c) {
        return this.every(interval, delay, unit, this.runnableCallback(c));
    }

    public static abstract class Task {
        public abstract void run(IRiemannClient var1);
    }
}

