/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.reporting;

import com.aphyr.riemann.client.AbstractRiemannClient;
import com.aphyr.riemann.client.EventDSL;
import com.aphyr.riemann.client.RiemannClient;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Clock;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.reporting.AbstractPollingReporter;
import com.yammer.metrics.stats.Snapshot;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiemannReporter
extends AbstractPollingReporter
implements MetricProcessor<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(RiemannReporter.class);
    public final AbstractRiemannClient riemann;
    public final Config c;

    public static void enable(Config config) {
        try {
            if (config == null) {
                throw new IllegalArgumentException("Config cannot be null");
            }
            RiemannReporter reporter = new RiemannReporter(config);
            reporter.start(config.period, config.unit);
        }
        catch (Exception e) {
            LOG.error("Error creating/starting Riemann reporter: ", (Throwable)e);
        }
    }

    public RiemannReporter(Config c) throws IOException {
        this(c, RiemannClient.tcp(new InetSocketAddress(c.host, c.port)));
        this.riemann.connect();
    }

    public RiemannReporter(Config c, AbstractRiemannClient riemann) {
        super(c.metricsRegistry, c.name);
        this.riemann = riemann;
        this.c = c;
    }

    public void run() {
        try {
            long epoch = this.c.clock.time() / 1000L;
            if (this.c.printVMMetrics) {
                this.sendVMMetrics(epoch);
            }
            this.sendRegularMetrics(epoch);
        }
        catch (Exception e) {
            LOG.warn("Error writing to Riemann", (Throwable)e);
        }
    }

    protected void sendRegularMetrics(Long epoch) {
        for (Map.Entry entry : this.getMetricsRegistry().groupedMetrics(this.c.predicate).entrySet()) {
            for (Map.Entry subEntry : ((SortedMap)entry.getValue()).entrySet()) {
                Metric metric = (Metric)subEntry.getValue();
                if (metric == null) continue;
                try {
                    metric.processWith((MetricProcessor)this, (MetricName)subEntry.getKey(), (Object)epoch);
                }
                catch (Exception ignored) {
                    LOG.error("Error sending regular metric:", (Throwable)ignored);
                }
            }
        }
    }

    private EventDSL newEvent() {
        EventDSL event = this.riemann.event();
        if (this.c.localHost != null) {
            event.host(this.c.localHost);
        }
        if (!this.c.tags.isEmpty()) {
            event.tags(this.c.tags);
        }
        return event;
    }

    public String service(MetricName name, String ... rest) {
        StringBuilder sb = new StringBuilder();
        if (null != this.c.prefix) {
            sb.append(this.c.prefix).append(this.c.separator);
        }
        sb.append(name.getGroup()).append(this.c.separator).append(name.getType()).append(this.c.separator);
        if (name.hasScope()) {
            sb.append(name.getScope()).append(this.c.separator);
        }
        sb.append(name.getName());
        for (String part : rest) {
            sb.append(this.c.separator);
            sb.append(part);
        }
        return sb.toString();
    }

    public String service(String ... parts) {
        StringBuilder sb = new StringBuilder();
        if (null != this.c.prefix) {
            sb.append(this.c.prefix).append(this.c.separator);
        }
        for (String p : parts) {
            sb.append(p).append(this.c.separator);
        }
        return sb.substring(0, sb.length() - this.c.separator.length());
    }

    public void processGauge(MetricName name, Gauge<?> gauge, Long epoch) {
        Object v = gauge.value();
        EventDSL e = this.newEvent().service(this.service(name, new String[0])).time(epoch);
        if (v instanceof Integer) {
            e.metric((Integer)v).send();
        } else if (v instanceof Long) {
            e.metric((Long)v).send();
        } else if (v instanceof Double) {
            e.metric((Double)v).send();
        } else if (v instanceof Float) {
            e.metric(((Float)v).floatValue()).send();
        } else if (v instanceof Number) {
            e.metric(((Number)v).floatValue()).send();
        }
    }

    public void processCounter(MetricName name, Counter counter, Long epoch) {
        this.newEvent().service(this.service(name, new String[0])).metric(counter.count()).time(epoch).send();
    }

    public void processMeter(MetricName name, Metered meter, Long epoch) {
        this.newEvent().service(this.service(name, new String[0])).metric(meter.oneMinuteRate()).time(epoch).send();
    }

    public void processHistogram(MetricName name, Histogram histogram, Long epoch) throws IOException {
        String service = this.service(name, new String[0]);
        this.sendSummary(name, (Summarizable)histogram, epoch);
        this.sendSample(name, (Sampling)histogram, epoch);
    }

    public void processTimer(MetricName name, Timer timer, Long epoch) {
        this.processMeter(name, (Metered)timer, epoch);
        this.sendSummary(name, (Summarizable)timer, epoch);
        this.sendSample(name, (Sampling)timer, epoch);
    }

    protected void sendVMMetrics(long epoch) {
        this.newEvent().time(epoch).service(this.service("jvm", "memory", "heap-usage")).metric(this.c.vm.heapUsage()).send();
        this.newEvent().time(epoch).service(this.service("jvm", "memory", "non-heap-usage")).metric(this.c.vm.nonHeapUsage()).send();
        for (Map.Entry pool : this.c.vm.memoryPoolUsage().entrySet()) {
            this.newEvent().time(epoch).service(this.service("jvm", "memory", "pool-usage", (String)pool.getKey())).metric((Double)pool.getValue()).send();
        }
        this.newEvent().time(epoch).service(this.service("jvm", "thread", "daemon-count")).metric(this.c.vm.daemonThreadCount()).send();
        this.newEvent().time(epoch).service(this.service("jvm", "thread", "count")).metric(this.c.vm.threadCount()).send();
        this.newEvent().time(epoch).service(this.service("jvm", "uptime")).metric(this.c.vm.uptime()).send();
        this.newEvent().time(epoch).service(this.service("jvm", "fd-usage")).metric(this.c.vm.fileDescriptorUsage()).send();
        for (Map.Entry entry : this.c.vm.threadStatePercentages().entrySet()) {
            this.newEvent().time(epoch).service(this.service("jvm", "thread", "state", ((Thread.State)((Object)entry.getKey())).toString().toLowerCase())).metric((Double)entry.getValue()).send();
        }
        for (Map.Entry entry : this.c.vm.garbageCollectors().entrySet()) {
            this.newEvent().time(epoch).service(this.service("jvm", "gc", (String)entry.getKey(), "time")).metric(((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getTime(TimeUnit.MILLISECONDS)).send();
            this.newEvent().time(epoch).service(this.service("jvm", "gc", (String)entry.getKey(), "runs")).metric(((VirtualMachineMetrics.GarbageCollectorStats)entry.getValue()).getRuns()).send();
        }
    }

    public void sendSummary(MetricName name, Summarizable metric, Long epoch) {
        this.newEvent().time(epoch).service(this.service(name, "min")).metric(metric.min()).send();
        this.newEvent().time(epoch).service(this.service(name, "max")).metric(metric.max()).send();
        this.newEvent().time(epoch).service(this.service(name, "mean")).metric(metric.mean()).send();
        this.newEvent().time(epoch).service(this.service(name, "stddev")).metric(metric.stdDev()).send();
    }

    public void sendSample(MetricName name, Sampling metric, Long epoch) {
        Snapshot s = metric.getSnapshot();
        this.newEvent().time(epoch).service(this.service(name, ".5")).metric(s.getMedian()).send();
        this.newEvent().time(epoch).service(this.service(name, ".75")).metric(s.get75thPercentile()).send();
        this.newEvent().time(epoch).service(this.service(name, ".95")).metric(s.get95thPercentile()).send();
        this.newEvent().time(epoch).service(this.service(name, ".98")).metric(s.get98thPercentile()).send();
        this.newEvent().time(epoch).service(this.service(name, ".99")).metric(s.get99thPercentile()).send();
        this.newEvent().time(epoch).service(this.service(name, ".999")).metric(s.get999thPercentile()).send();
    }

    public static final class ConfigBuilder {
        private MetricsRegistry metricsRegistry = Metrics.defaultRegistry();
        private MetricPredicate predicate = MetricPredicate.ALL;
        private boolean printVMMetrics = true;
        private String host = "localhost";
        private int port = 5555;
        private long period = 60L;
        private TimeUnit unit = TimeUnit.SECONDS;
        private String prefix = null;
        private String separator = " ";
        private final VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();
        private Clock clock = Clock.defaultClock();
        private String name = "riemann-reporter";
        private String localHost = null;
        private List<String> tags = new ArrayList<String>();

        private ConfigBuilder() {
        }

        public Config build() {
            return new Config(this.metricsRegistry, this.predicate, this.printVMMetrics, this.host, this.port, this.period, this.unit, this.prefix, this.separator, this.clock, this.name, this.localHost, this.tags);
        }

        public ConfigBuilder metricsRegistry(MetricsRegistry r) {
            this.metricsRegistry = r;
            return this;
        }

        public ConfigBuilder predicate(MetricPredicate p) {
            this.predicate = p;
            return this;
        }

        public ConfigBuilder printVMMetrics(Boolean p) {
            this.printVMMetrics = p;
            return this;
        }

        public ConfigBuilder host(String h) {
            this.host = h;
            return this;
        }

        public ConfigBuilder port(int p) {
            this.port = p;
            return this;
        }

        public ConfigBuilder period(long p) {
            this.period = p;
            return this;
        }

        public ConfigBuilder unit(TimeUnit t) {
            this.unit = t;
            return this;
        }

        public ConfigBuilder prefix(String p) {
            this.prefix = p;
            return this;
        }

        public ConfigBuilder separator(String s) {
            this.separator = s;
            return this;
        }

        public ConfigBuilder clock(Clock c) {
            this.clock = c;
            return this;
        }

        public ConfigBuilder name(String n) {
            this.name = n;
            return this;
        }

        public ConfigBuilder localHost(String l) {
            this.localHost = l;
            return this;
        }

        public ConfigBuilder tags(Collection<String> ts) {
            this.tags.clear();
            this.tags.addAll(ts);
            return this;
        }
    }

    public static class Config {
        public final MetricsRegistry metricsRegistry;
        public final MetricPredicate predicate;
        public final boolean printVMMetrics;
        public final String host;
        public final int port;
        public final long period;
        public final TimeUnit unit;
        public final String prefix;
        public final String separator;
        public final VirtualMachineMetrics vm = VirtualMachineMetrics.getInstance();
        public final Clock clock;
        public final String name;
        public final String localHost;
        public final List<String> tags;

        private Config(MetricsRegistry metricsRegistry, MetricPredicate predicate, boolean printVMMetrics, String host, int port, long period, TimeUnit unit, String prefix, String separator, Clock clock, String name, String localHost, List<String> tags) {
            this.metricsRegistry = metricsRegistry;
            this.predicate = predicate;
            this.printVMMetrics = printVMMetrics;
            this.host = host;
            this.port = port;
            this.period = period;
            this.unit = unit;
            this.prefix = prefix;
            this.separator = separator;
            this.clock = clock;
            this.name = name;
            this.localHost = localHost;
            this.tags = tags;
        }

        public static ConfigBuilder newBuilder() {
            return new ConfigBuilder();
        }

        public String toString() {
            return "Config{print_metrics:" + this.printVMMetrics + ", host:" + this.host + ", port:" + this.port + ", period:" + this.period + ", unit:" + (Object)((Object)this.unit) + ", prefix:" + this.prefix + ", separator:" + this.separator + ", clock:" + this.clock + ", name:" + this.name + ", localhost:" + this.localHost + ", metrics_registry:" + this.metricsRegistry + ", predicate:" + this.predicate + ", tags:" + Arrays.toString(this.tags.toArray()) + "}";
        }
    }
}

