/*
 * Decompiled with CFR 0.152.
 */
package com.aphyr.riemann.client;

import com.aphyr.riemann.Proto;
import com.aphyr.riemann.client.Promise;
import com.aphyr.riemann.client.SynchronousTransport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.handler.codec.protobuf.ProtobufEncoder;

public class UdpTransport
implements SynchronousTransport {
    public static final Promise<Proto.Msg> blackhole = new Promise();
    public static final ProtobufEncoder pbEncoder = new ProtobufEncoder();
    public static final DiscardHandler discardHandler = new DiscardHandler();
    public static final int DEFAULT_PORT = 5555;
    public volatile State state = State.DISCONNECTED;
    public volatile Channel channel = null;
    public volatile ConnectionlessBootstrap bootstrap;
    public final AtomicLong connectTimeout = new AtomicLong(5000L);
    public final AtomicInteger sendBufferSize = new AtomicInteger(16384);
    public final InetSocketAddress address;

    public UdpTransport(InetSocketAddress address) {
        this.address = address;
    }

    public UdpTransport(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port));
    }

    public UdpTransport(String host) throws IOException {
        this(host, 5555);
    }

    public UdpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Override
    public boolean isConnected() {
        return this.state == State.CONNECTED;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (this.state != State.DISCONNECTED) {
            return;
        }
        this.state = State.CONNECTING;
        NioDatagramChannelFactory channelFactory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool());
        this.bootstrap = new ConnectionlessBootstrap((ChannelFactory)channelFactory);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() {
                ChannelPipeline p = Channels.pipeline();
                p.addLast("protobuf-encoder", (ChannelHandler)pbEncoder);
                p.addLast("discard", (ChannelHandler)discardHandler);
                return p;
            }
        });
        this.bootstrap.setOption("remoteAddress", (Object)this.address);
        this.bootstrap.setOption("sendBufferSize", (Object)this.sendBufferSize.get());
        ChannelFuture result = this.bootstrap.connect().awaitUninterruptibly();
        if (!result.isSuccess()) {
            this.disconnect(true);
            throw new IOException("Connection failed", result.getCause());
        }
        this.channel = result.getChannel();
        this.channel.setReadable(false);
        this.state = State.CONNECTED;
    }

    @Override
    public void disconnect() throws IOException {
        this.disconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnect(boolean force) throws IOException {
        if (!force && this.state != State.CONNECTED) {
            return;
        }
        try {
            this.channel.close().awaitUninterruptibly();
            this.bootstrap.releaseExternalResources();
        }
        finally {
            this.bootstrap = null;
            this.channel = null;
            this.state = State.DISCONNECTED;
        }
    }

    @Override
    public void reconnect() throws IOException {
        this.disconnect();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public Proto.Msg sendRecvMessage(Proto.Msg msg) {
        throw new UnsupportedOperationException("UDP transport doesn't support receiving messages");
    }

    @Override
    public Proto.Msg sendMaybeRecvMessage(Proto.Msg msg) {
        this.channel.write((Object)msg);
        return null;
    }

    public static class DiscardHandler
    extends SimpleChannelHandler {
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
            e.getCause().printStackTrace();
            Channel ch = e.getChannel();
            ch.close();
        }
    }

    public static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        DISCONNECTING;

    }
}

