/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.sort;

import com.aoindustries.lang.RuntimeUtils;
import com.aoindustries.util.AtomicSequence;
import com.aoindustries.util.IntList;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.sort.BaseIntegerSortAlgorithm;
import com.aoindustries.util.sort.IntegerRadixSort;
import com.aoindustries.util.sort.SortStatistics;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public final class IntegerRadixSortExperimental
extends BaseIntegerSortAlgorithm {
    private static final int MIN_RADIX_SORT_SIZE = 256;
    private static final int FIRST_BITS_PER_PASS = 4;
    private static final int R_BITS_PER_PASS = 8;
    private static final boolean ENABLE_CONCURRENCY = true;
    private static final int MIN_CONCURRENCY_SIZE = 512;
    private static final ExecutorService executor = Executors.newFixedThreadPool(RuntimeUtils.getAvailableProcessors(), new ThreadFactory(){
        private final Sequence idSequence = new AtomicSequence();

        @Override
        public Thread newThread(Runnable target) {
            return new Thread(target, IntegerRadixSortExperimental.class.getName() + ".executor: id=" + this.idSequence.getNextSequenceValue());
        }
    });
    private static final IntegerRadixSortExperimental instance = new IntegerRadixSortExperimental();
    private static final int UNSIGNED_OFFSET = Integer.MIN_VALUE;

    public static IntegerRadixSortExperimental getInstance() {
        return instance;
    }

    private IntegerRadixSortExperimental() {
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public <N extends Number> void sort(List<N> list, SortStatistics stats) {
        IntegerRadixSort.getInstance().sort(list, stats);
    }

    @Override
    public <N extends Number> void sort(N[] array, SortStatistics stats) {
        IntegerRadixSort.getInstance().sort((Number[])array, stats);
    }

    @Override
    public void sort(IntList list, SortStatistics stats) {
        IntegerRadixSort.getInstance().sort(list, stats);
    }

    @Override
    public void sort(int[] array, SortStatistics stats) {
        if (stats != null) {
            stats.sortStarting();
        }
        if (array.length < 256) {
            if (stats != null) {
                stats.sortSwitchingAlgorithms();
            }
            Arrays.sort(array);
        } else {
            ConcurrentLinkedQueue futures = new ConcurrentLinkedQueue();
            IntegerRadixSortExperimental.sort(array, 0, array.length, 28, futures);
            try {
                while (!futures.isEmpty()) {
                    ((Future)futures.remove()).get();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        if (stats != null) {
            stats.sortEnding();
        }
    }

    public static void sort(final int[] array, int offset, int end, int shift, final Queue<Future<?>> futures) {
        int x;
        int BITS_PER_PASS = shift + 8 == 32 ? 4 : 8;
        int PASS_SIZE = 1 << BITS_PER_PASS;
        int PASS_MASK = PASS_SIZE - 1;
        int[] last = new int[PASS_SIZE];
        int[] pointer = new int[PASS_SIZE];
        for (x = offset; x < end; ++x) {
            int n = array[x] + Integer.MIN_VALUE >> shift & PASS_MASK;
            last[n] = last[n] + 1;
        }
        last[0] = last[0] + offset;
        pointer[0] = offset;
        for (x = 1; x < PASS_SIZE; ++x) {
            pointer[x] = last[x - 1];
            int n = x;
            last[n] = last[n] + last[x - 1];
        }
        for (x = 0; x < PASS_SIZE; ++x) {
            while (pointer[x] != last[x]) {
                int value = array[pointer[x]];
                int y = value + Integer.MIN_VALUE >> shift & PASS_MASK;
                while (x != y) {
                    int temp = array[pointer[y]];
                    int n = y;
                    int n2 = pointer[n];
                    pointer[n] = n2 + 1;
                    array[n2] = value;
                    value = temp;
                    y = value + Integer.MIN_VALUE >> shift & PASS_MASK;
                }
                int n = x;
                int n3 = pointer[n];
                pointer[n] = n3 + 1;
                array[n3] = value;
            }
        }
        if (shift > 0) {
            shift -= BITS_PER_PASS;
            for (x = 0; x < PASS_SIZE; ++x) {
                int size;
                int n = size = x > 0 ? pointer[x] - pointer[x - 1] : pointer[0] - offset;
                if (size > 64) {
                    final int newEnd = pointer[x];
                    final int newOffset = pointer[x] - size;
                    if (newEnd - newOffset >= 512) {
                        final int finalShift = shift;
                        futures.add(executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                IntegerRadixSortExperimental.sort(array, newOffset, newEnd, finalShift, futures);
                            }
                        }));
                        continue;
                    }
                    IntegerRadixSortExperimental.sort(array, newOffset, newEnd, shift, futures);
                    continue;
                }
                if (size <= 1) continue;
                IntegerRadixSortExperimental.insertionSort(array, pointer[x] - size, pointer[x]);
            }
        }
    }

    private static void insertionSort(int[] array, int offset, int end) {
        for (int x = offset; x < end; ++x) {
            for (int y = x; y > offset && array[y - 1] > array[y]; --y) {
                int temp = array[y];
                array[y] = array[y - 1];
                array[y - 1] = temp;
            }
        }
    }
}

