/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.schedule;

import java.util.Calendar;

public class DayDuration {
    public static final DayDuration ZERO_DAYS = new DayDuration(0, Unit.DAYS);
    private final int count;
    private final Unit unit;

    public static DayDuration valueOf(String duration) {
        int spacePos = duration.indexOf(32);
        if (spacePos == -1) {
            throw new IllegalArgumentException("Space not found in duration: " + duration);
        }
        return DayDuration.getInstance(Integer.parseInt(duration.substring(0, spacePos)), Unit.valueOfUnit(duration.substring(spacePos + 1)));
    }

    public static DayDuration getInstance(int count, Unit unit) {
        if (count == 0 && unit == Unit.DAYS) {
            return ZERO_DAYS;
        }
        return new DayDuration(count, unit);
    }

    protected DayDuration(int count, Unit unit) {
        this.count = count;
        this.unit = unit;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        this.unit.toString(this.count, sb);
    }

    public int getCount() {
        return this.count;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void offset(Calendar cal) {
        this.unit.offset(this.count, cal);
    }

    public static enum Unit {
        DAYS{

            @Override
            void toString(int count, StringBuilder sb) {
                sb.append(count).append(count == 1 ? " day" : " days");
            }

            @Override
            void offset(int count, Calendar cal) {
                cal.add(5, count);
            }
        }
        ,
        WEEKS{

            @Override
            void toString(int count, StringBuilder sb) {
                sb.append(count).append(count == 1 ? " week" : " weeks");
            }

            @Override
            void offset(int count, Calendar cal) {
                cal.add(3, count);
            }
        }
        ,
        MONTHS{

            @Override
            void toString(int count, StringBuilder sb) {
                sb.append(count).append(count == 1 ? " month" : " months");
            }

            @Override
            void offset(int count, Calendar cal) {
                cal.add(2, count);
            }
        }
        ,
        YEARS{

            @Override
            void toString(int count, StringBuilder sb) {
                sb.append(count).append(count == 1 ? " year" : " years");
            }

            @Override
            void offset(int count, Calendar cal) {
                cal.add(1, count);
            }
        };


        static Unit valueOfUnit(String unit) throws IllegalArgumentException {
            if ("day".equalsIgnoreCase(unit) || "days".equalsIgnoreCase(unit)) {
                return DAYS;
            }
            if ("week".equalsIgnoreCase(unit) || "weeks".equalsIgnoreCase(unit)) {
                return WEEKS;
            }
            if ("month".equalsIgnoreCase(unit) || "months".equalsIgnoreCase(unit)) {
                return MONTHS;
            }
            if ("year".equalsIgnoreCase(unit) || "years".equalsIgnoreCase(unit)) {
                return YEARS;
            }
            throw new IllegalArgumentException("Unknown duration unit: " + unit);
        }

        abstract void toString(int var1, StringBuilder var2);

        abstract void offset(int var1, Calendar var2);
    }
}

