/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IntegerSerializer
implements Serializer<Integer> {
    private final byte[] buffer = new byte[4];

    @Override
    public boolean isFixedSerializedSize() {
        return true;
    }

    @Override
    public long getSerializedSize(Integer value) {
        return 4L;
    }

    @Override
    public void serialize(Integer value, OutputStream out) throws IOException {
        PersistentCollections.intToBuffer(value, this.buffer);
        out.write(this.buffer, 0, 4);
    }

    @Override
    public Integer deserialize(InputStream in) throws IOException {
        IoUtils.readFully(in, this.buffer, 0, 4);
        return PersistentCollections.bufferToInt(this.buffer);
    }
}

