/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DoubleSerializer
implements Serializer<Double> {
    private final byte[] buffer = new byte[8];

    @Override
    public boolean isFixedSerializedSize() {
        return true;
    }

    @Override
    public long getSerializedSize(Double value) {
        return 8L;
    }

    @Override
    public void serialize(Double value, OutputStream out) throws IOException {
        PersistentCollections.longToBuffer(Double.doubleToRawLongBits(value), this.buffer);
        out.write(this.buffer, 0, 8);
    }

    @Override
    public Double deserialize(InputStream in) throws IOException {
        IoUtils.readFully(in, this.buffer, 0, 8);
        return Double.longBitsToDouble(PersistentCollections.bufferToLong(this.buffer));
    }
}

