/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.BufferManager;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CharArraySerializer
implements Serializer<char[]> {
    @Override
    public boolean isFixedSerializedSize() {
        return false;
    }

    @Override
    public long getSerializedSize(char[] value) {
        return 4 + value.length / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(char[] chars, OutputStream out) throws IOException {
        byte[] bytes = BufferManager.getBytes();
        try {
            int count;
            int len;
            PersistentCollections.intToBuffer(len, bytes);
            out.write(bytes, 0, 4);
            int pos = 0;
            for (len = chars.length; len > 0; len -= count) {
                count = 2048;
                if (len < count) {
                    count = len;
                }
                int charsIndex = 0;
                int bytesIndex = 0;
                while (charsIndex < count) {
                    PersistentCollections.charToBuffer(chars[pos + charsIndex], bytes, bytesIndex);
                    ++charsIndex;
                    bytesIndex += 2;
                }
                out.write(bytes, 0, count * 2);
                pos += count;
            }
        }
        finally {
            BufferManager.release(bytes, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] deserialize(InputStream in) throws IOException {
        byte[] bytes = BufferManager.getBytes();
        try {
            int count;
            int len;
            IoUtils.readFully(in, bytes, 0, 4);
            char[] chars = new char[len];
            int pos = 0;
            for (len = PersistentCollections.bufferToInt(bytes); len > 0; len -= count) {
                count = 2048;
                if (len < count) {
                    count = len;
                }
                IoUtils.readFully(in, bytes, pos, len);
                int charsIndex = 0;
                int bytesIndex = 0;
                while (charsIndex < count) {
                    chars[pos + charsIndex] = PersistentCollections.bufferToChar(bytes, bytesIndex);
                    ++charsIndex;
                    bytesIndex += 2;
                }
                pos += count;
            }
            char[] cArray = chars;
            return cArray;
        }
        finally {
            BufferManager.release(bytes, false);
        }
    }
}

