/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.io.IoUtils;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.Serializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArraySerializer
implements Serializer<byte[]> {
    private final byte[] ioBuffer = new byte[4];

    @Override
    public boolean isFixedSerializedSize() {
        return false;
    }

    @Override
    public long getSerializedSize(byte[] value) {
        return 4 + value.length;
    }

    @Override
    public void serialize(byte[] value, OutputStream out) throws IOException {
        PersistentCollections.intToBuffer(value.length, this.ioBuffer);
        out.write(this.ioBuffer, 0, 4);
        out.write(value);
    }

    @Override
    public byte[] deserialize(InputStream in) throws IOException {
        IoUtils.readFully(in, this.ioBuffer, 0, 4);
        int length = PersistentCollections.bufferToInt(this.ioBuffer);
        byte[] value = new byte[length];
        IoUtils.readFully(in, value, 0, length);
        return value;
    }
}

