/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.util.persistent.PersistentBuffer;
import com.aoindustries.util.persistent.PersistentCollections;
import com.aoindustries.util.persistent.ProtectionLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public abstract class AbstractPersistentBuffer
implements PersistentBuffer {
    protected final ProtectionLevel protectionLevel;
    private final byte[] ioBuffer = new byte[8];

    public AbstractPersistentBuffer(ProtectionLevel protectionLevel) {
        this.protectionLevel = protectionLevel;
    }

    @Override
    public ProtectionLevel getProtectionLevel() {
        return this.protectionLevel;
    }

    @Override
    public void get(long position, byte[] buff, int off, int len) throws IOException {
        while (len > 0) {
            int count = this.getSome(position, buff, off, len);
            position += (long)count;
            off += count;
            len -= count;
        }
    }

    @Override
    public boolean getBoolean(long position) throws IOException {
        return this.get(position) != 0;
    }

    @Override
    public byte get(long position) throws IOException {
        this.get(position, this.ioBuffer, 0, 1);
        return this.ioBuffer[0];
    }

    @Override
    public int getInt(long position) throws IOException {
        this.get(position, this.ioBuffer, 0, 4);
        return PersistentCollections.bufferToInt(this.ioBuffer);
    }

    @Override
    public long getLong(long position) throws IOException {
        this.get(position, this.ioBuffer, 0, 8);
        return PersistentCollections.bufferToLong(this.ioBuffer);
    }

    @Override
    public void put(long position, byte value) throws IOException {
        this.ioBuffer[0] = value;
        this.put(position, this.ioBuffer, 0, 1);
    }

    @Override
    public void putInt(long position, int value) throws IOException {
        PersistentCollections.intToBuffer(value, this.ioBuffer);
        this.put(position, this.ioBuffer, 0, 4);
    }

    @Override
    public void putLong(long position, long value) throws IOException {
        PersistentCollections.longToBuffer(value, this.ioBuffer);
        this.put(position, this.ioBuffer, 0, 8);
    }

    @Override
    public InputStream getInputStream(final long position, final long length) throws IOException, BufferUnderflowException {
        return new InputStream(){
            private boolean closed = false;
            private long curPosition = position;
            private long curRemaining = length;

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
                if (this.curRemaining < 1L) {
                    throw new BufferUnderflowException();
                }
                int value = AbstractPersistentBuffer.this.get(this.curPosition++) & 0xFF;
                --this.curRemaining;
                return value;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
                if (len < 0) {
                    throw new IllegalArgumentException("len<0: " + len);
                }
                if (len == 0) {
                    return 0;
                }
                if (this.curRemaining < (long)len) {
                    if (this.curRemaining <= 0L) {
                        return -1;
                    }
                    len = (int)this.curRemaining;
                }
                try {
                    int numBytes = AbstractPersistentBuffer.this.getSome(this.curPosition, b, off, len);
                    this.curPosition += (long)numBytes;
                    this.curRemaining -= (long)numBytes;
                    return numBytes;
                }
                catch (BufferUnderflowException err) {
                    return -1;
                }
            }

            @Override
            public long skip(long n) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
                if (n <= 0L) {
                    return 0L;
                }
                if (this.curRemaining < n) {
                    if (this.curRemaining <= 0L) {
                        return 0L;
                    }
                    n = this.curRemaining;
                }
                this.curPosition += n;
                this.curRemaining -= n;
                return n;
            }

            @Override
            public int available() throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
                return 0;
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }

    @Override
    public OutputStream getOutputStream(final long position, final long length) throws IOException, BufferOverflowException {
        return new OutputStream(){
            private boolean closed = false;
            private long curPosition = position;
            private long curRemaining = length;

            @Override
            public void write(int b) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
                if (this.curRemaining < 1L) {
                    throw new BufferOverflowException();
                }
                AbstractPersistentBuffer.this.put(this.curPosition++, (byte)b);
                --this.curRemaining;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                if (this.closed) {
                    throw new IOException("Stream closed");
                }
                if (this.curRemaining < (long)len) {
                    throw new BufferOverflowException();
                }
                AbstractPersistentBuffer.this.put(this.curPosition, b, off, len);
                this.curPosition += (long)len;
                this.curRemaining -= (long)len;
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }
}

