/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.persistent;

import com.aoindustries.util.persistent.PersistentBlockBuffer;
import com.aoindustries.util.persistent.PersistentBuffer;
import com.aoindustries.util.persistent.ProtectionLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractPersistentBlockBuffer
implements PersistentBlockBuffer {
    protected final PersistentBuffer pbuffer;

    public AbstractPersistentBlockBuffer(PersistentBuffer pbuffer) {
        this.pbuffer = pbuffer;
    }

    @Override
    public boolean isClosed() {
        return this.pbuffer.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.pbuffer.close();
    }

    @Override
    public ProtectionLevel getProtectionLevel() {
        return this.pbuffer.getProtectionLevel();
    }

    @Override
    public void barrier(boolean force) throws IOException {
        this.pbuffer.barrier(force);
    }

    protected boolean isInBounds(long id, long offset, long len) throws IOException {
        if (id < 0L) {
            throw new IllegalArgumentException("id<0: " + id);
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("offset<0: " + offset);
        }
        if (len < 0L) {
            throw new IllegalArgumentException("len<0: " + len);
        }
        long totalSize = offset + len;
        if (totalSize < 0L) {
            throw new IllegalArgumentException("offset+len>Long.MAX_VALUE: offset=" + offset + ", len=" + len);
        }
        long blockSize = this.getBlockSize(id);
        return totalSize <= blockSize;
    }

    @Override
    public void get(long id, long offset, byte[] buff, int off, int len) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + (long)len);
        this.pbuffer.get(startAddress, buff, off, len);
    }

    @Override
    public int getInt(long id, long offset) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + 4L);
        return this.pbuffer.getInt(startAddress);
    }

    @Override
    public long getLong(long id, long offset) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + 8L);
        return this.pbuffer.getLong(startAddress);
    }

    @Override
    public InputStream getInputStream(long id, long offset, long length) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + length);
        return this.pbuffer.getInputStream(startAddress, length);
    }

    @Override
    public void put(long id, long offset, byte[] buff, int off, int len) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + (long)len);
        this.pbuffer.put(startAddress, buff, off, len);
    }

    @Override
    public void putInt(long id, long offset, int value) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + 4L);
        this.pbuffer.putInt(startAddress, value);
    }

    @Override
    public void putLong(long id, long offset, long value) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + 8L);
        this.pbuffer.putLong(startAddress, value);
    }

    @Override
    public OutputStream getOutputStream(long id, long offset, long length) throws IOException {
        long startAddress = this.getBlockAddress(id) + offset;
        this.ensureCapacity(startAddress + length);
        return this.pbuffer.getOutputStream(startAddress, length);
    }

    protected abstract long getBlockAddress(long var1) throws IOException;

    protected abstract void ensureCapacity(long var1) throws IOException;
}

