/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.logging;

import com.aoindustries.util.StringUtility;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessTimer
implements Runnable {
    private final Logger logger;
    private final Random random;
    private final String sourceClass;
    private final String sourceMethod;
    private final String subject;
    private final String processDescription;
    private final long startTime;
    private final long maximumTime;
    private final long reminderInterval;
    private volatile Thread thread;
    private volatile boolean isFinished;
    private volatile boolean isSleeping;

    public ProcessTimer(Logger logger, Random random, String sourceClass, String sourceMethod, String subject, String processDescription, long maximumTime, long reminderInterval) {
        this.logger = logger;
        this.random = random;
        this.sourceClass = sourceClass;
        this.sourceMethod = sourceMethod;
        this.subject = subject;
        this.processDescription = processDescription;
        this.startTime = System.currentTimeMillis();
        this.maximumTime = maximumTime;
        this.reminderInterval = reminderInterval;
    }

    public void finished() {
        Thread T;
        this.isFinished = true;
        if (this.isSleeping && (T = this.thread) != null) {
            T.interrupt();
        }
    }

    @Override
    public void run() {
        block10: {
            this.thread = Thread.currentThread();
            try {
                try {
                    this.isSleeping = true;
                    Thread.sleep(this.maximumTime);
                }
                catch (InterruptedException err) {
                    if (!this.isFinished) {
                        this.logger.log(Level.WARNING, "Interrupted when not finished", err);
                    }
                    Thread.currentThread().interrupt();
                }
                this.isSleeping = false;
                if (this.isFinished) break block10;
                this.logInfo(false);
                while (!this.isFinished) {
                    try {
                        this.isSleeping = true;
                        Thread.sleep(this.reminderInterval);
                    }
                    catch (InterruptedException err) {
                        if (!this.isFinished) {
                            this.logger.log(Level.WARNING, "Interrupted when not finished", err);
                        }
                        Thread.currentThread().interrupt();
                    }
                    this.isSleeping = false;
                    if (this.isFinished) continue;
                    this.logInfo(true);
                }
            }
            finally {
                this.thread = null;
            }
        }
    }

    private void logInfo(boolean isReminder) {
        long currentTime = System.currentTimeMillis();
        this.logger.logp(Level.INFO, this.sourceClass, this.sourceMethod, this.subject + ": Process=" + this.processDescription + ", Duration=" + StringUtility.getTimeLengthString(currentTime - this.startTime));
    }
}

