/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n.servlet;

import com.aoindustries.util.i18n.Locales;
import com.aoindustries.util.i18n.ModifiableResourceBundle;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SetResourceBundleValue
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String role;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.role = config.getInitParameter("role");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("*".equals(this.role) || request.isUserInRole(this.role)) {
            String baseName = request.getParameter("baseName");
            Locale locale = Locales.parseLocale(request.getParameter("locale"));
            String key = request.getParameter("key");
            String value = request.getParameter("value");
            boolean modified = "true".equals(request.getParameter("modified"));
            ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale);
            if (!resourceBundle.getLocale().equals(locale)) {
                throw new AssertionError((Object)"resourceBundle.locale!=locale");
            }
            if (!(resourceBundle instanceof ModifiableResourceBundle)) {
                throw new AssertionError((Object)"resourceBundle is not a ModifiableResourceBundle");
            }
            if (value.isEmpty()) {
                ((ModifiableResourceBundle)resourceBundle).removeKey(key);
            } else {
                ((ModifiableResourceBundle)resourceBundle).setString(key, "[BLANK]".equals(value) ? "" : value, modified);
            }
            PrintWriter out = response.getWriter();
            out.println("<html>");
            out.println("  <head><title>Value Successfully Set</title></head>");
            out.println("  <body>Value Successfully Set</body>");
            out.println("</html>");
        } else {
            response.sendError(403);
        }
    }
}

