/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Locales {
    public static final Locale ROOT = Locale.ROOT;
    public static final Locale ARABIC = Locales.parseLocale("ar");
    public static final Locale BULGARIAN = Locales.parseLocale("bg");
    public static final Locale CATALAN = Locales.parseLocale("ca");
    public static final Locale CZECH = Locales.parseLocale("cs");
    public static final Locale DANISH = Locales.parseLocale("da");
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale GREEK = Locales.parseLocale("el");
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale SPANISH = Locales.parseLocale("es");
    public static final Locale ESTONIAN = Locales.parseLocale("et");
    public static final Locale PERSIAN = Locales.parseLocale("fa");
    public static final Locale FINNISH = Locales.parseLocale("fi");
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale HINDI = Locales.parseLocale("hi");
    public static final Locale CROATIAN = Locales.parseLocale("hr");
    public static final Locale HUNGARIAN = Locales.parseLocale("hu");
    public static final Locale INDONESIAN = Locales.parseLocale("in");
    public static final Locale ICELANDIC = Locales.parseLocale("is");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale HEBREW = Locales.parseLocale("iw");
    public static final Locale LITHUANIAN = Locales.parseLocale("lt");
    public static final Locale LATVIAN = Locales.parseLocale("lv");
    public static final Locale DUTCH = Locales.parseLocale("nl");
    public static final Locale NORWEGIAN = Locales.parseLocale("no");
    public static final Locale POLISH = Locales.parseLocale("pl");
    public static final Locale PORTUGUESE = Locales.parseLocale("pt");
    public static final Locale ROMANIAN = Locales.parseLocale("ro");
    public static final Locale RUSSIAN = Locales.parseLocale("ru");
    public static final Locale SLOVAK = Locales.parseLocale("sk");
    public static final Locale SLOVENIAN = Locales.parseLocale("sl");
    public static final Locale SERBIAN = Locales.parseLocale("sr");
    public static final Locale SWEDISH = Locales.parseLocale("sv");
    public static final Locale TURKISH = Locales.parseLocale("tr");
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale FRANCE = Locale.FRANCE;
    public static final Locale GERMANY = Locale.GERMANY;
    public static final Locale ITALY = Locale.ITALY;
    public static final Locale JAPAN = Locale.JAPAN;
    public static final Locale KOREA = Locale.KOREA;
    public static final Locale CHINA = Locale.SIMPLIFIED_CHINESE;
    public static final Locale PRC = Locale.SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = Locale.TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.UK;
    public static final Locale US = Locale.US;
    public static final Locale CANADA = Locale.CANADA;
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;

    private Locales() {
    }

    static String getScript(Locale locale) {
        try {
            Method method = Locale.class.getMethod("getScript", new Class[0]);
            return (String)method.invoke((Object)locale, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            AssertionError ae = new AssertionError((Object)"getScript() should be accessible");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
        catch (InvocationTargetException e) {
            AssertionError ae = new AssertionError((Object)"getScript() should not throw any exceptions");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    static Set<Character> getExtensionKeys(Locale locale) {
        try {
            Method method = Locale.class.getMethod("getExtensionKeys", new Class[0]);
            return (Set)method.invoke((Object)locale, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return Collections.emptySet();
        }
        catch (IllegalAccessException e) {
            AssertionError ae = new AssertionError((Object)"getExtensionKeys() should be accessible");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
        catch (InvocationTargetException e) {
            AssertionError ae = new AssertionError((Object)"getExtensionKeys() should not throw any exceptions");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
    }

    public static Locale getCachedLocale(String language, String country, String variant) {
        return LocaleCache.getCachedLocale(language, country, variant);
    }

    private static int indexOfSeparator(String locale, int fromIndex) {
        int pos1 = locale.indexOf(95, fromIndex);
        int pos2 = locale.indexOf(45, fromIndex);
        if (pos1 == -1) {
            return pos2;
        }
        if (pos2 == -1) {
            return pos1;
        }
        return Math.min(pos1, pos2);
    }

    public static Locale parseLocale(String locale) {
        int pos = Locales.indexOfSeparator(locale, 0);
        if (pos == -1) {
            return Locales.getCachedLocale(locale, "", "");
        }
        int pos2 = Locales.indexOfSeparator(locale, pos + 1);
        if (pos2 == -1) {
            return Locales.getCachedLocale(locale.substring(0, pos).toLowerCase(Locale.ROOT), locale.substring(pos + 1).toUpperCase(Locale.ROOT), "");
        }
        return Locales.getCachedLocale(locale.substring(0, pos).toLowerCase(Locale.ROOT), locale.substring(pos + 1, pos2).toUpperCase(Locale.ROOT), locale.substring(pos2 + 1));
    }

    public static boolean isRightToLeft(Locale locale) {
        String language = locale.getLanguage();
        return "ar".equals(language) || "iw".equals(language) || "fa".equals(language);
    }

    private static class LocaleCache {
        private static final ConcurrentMap<CacheKey, Locale> locales = new ConcurrentHashMap<CacheKey, Locale>(16, 0.75f, 1);

        private static Locale getCachedLocale(String language, String country, String variant) {
            Locale existing;
            CacheKey key = new CacheKey(language = language.toLowerCase(Locale.ROOT), country = country.toUpperCase(Locale.ROOT), variant);
            Locale locale = (Locale)locales.get(key);
            if (locale == null && (existing = locales.putIfAbsent(key, locale = new Locale(language, country, variant))) != null) {
                locale = existing;
            }
            return locale;
        }

        private LocaleCache() {
        }

        static {
            for (Locale locale : Locale.getAvailableLocales()) {
                if (!Locales.getScript(locale).isEmpty() || !Locales.getExtensionKeys(locale).isEmpty()) continue;
                locales.put(new CacheKey(locale.getLanguage(), locale.getCountry(), locale.getVariant()), locale);
            }
        }

        private static class CacheKey {
            private final String language;
            private final String country;
            private final String variant;

            private CacheKey(String language, String country, String variant) {
                this.language = language;
                this.country = country;
                this.variant = variant;
            }

            public boolean equals(Object o) {
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)o;
                return this.language.equals(other.language) && this.country.equals(other.country) && this.variant.equals(other.variant);
            }

            public int hashCode() {
                int hash = this.language.hashCode();
                hash = hash * 31 + this.country.hashCode();
                hash = hash * 31 + this.variant.hashCode();
                return hash;
            }
        }
    }
}

