/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import com.aoindustries.util.AoCollections;
import com.aoindustries.util.i18n.EditableResourceBundle;
import com.aoindustries.util.i18n.LocaleComparator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class EditableResourceBundleSet {
    private final String baseName;
    private final SortedSet<Locale> locales;
    private final Map<Locale, EditableResourceBundle> bundles = new ConcurrentHashMap<Locale, EditableResourceBundle>();

    public EditableResourceBundleSet(String baseName, Collection<Locale> locales) {
        TreeSet<Locale> modifiableSet = new TreeSet<Locale>(LocaleComparator.getInstance());
        modifiableSet.addAll(locales);
        this.baseName = baseName;
        this.locales = AoCollections.optimalUnmodifiableSortedSet(modifiableSet);
    }

    public EditableResourceBundleSet(String baseName, Locale ... locales) {
        this(baseName, Arrays.asList(locales));
    }

    void addBundle(EditableResourceBundle bundle) {
        Locale locale = bundle.getBundleLocale();
        if (!this.locales.contains(locale)) {
            throw new AssertionError((Object)("locale not in locales: " + locale));
        }
        this.bundles.put(locale, bundle);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public SortedSet<Locale> getLocales() {
        return this.locales;
    }

    public EditableResourceBundle getResourceBundle(Locale locale) {
        EditableResourceBundle localeBundle = this.bundles.get(locale);
        if (localeBundle == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(this.baseName, locale);
            if (!resourceBundle.getLocale().equals(locale)) {
                throw new AssertionError((Object)("ResourceBundle not for this locale: " + locale));
            }
            if (!(resourceBundle instanceof EditableResourceBundle)) {
                throw new AssertionError((Object)("ResourceBundle is not a EditableResourceBundle: " + resourceBundle));
            }
            localeBundle = (EditableResourceBundle)resourceBundle;
            if (localeBundle.getBundleSet() != this) {
                throw new AssertionError((Object)("EditableResourceBundle not for this EditableResourceBundleSet: " + localeBundle));
            }
            if (!localeBundle.getBundleLocale().equals(locale)) {
                throw new AssertionError((Object)("EditableResourceBundle not for this locale: " + locale));
            }
        }
        return localeBundle;
    }
}

