/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import com.aoindustries.io.Encoder;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.UnsynchronizedSequence;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import com.aoindustries.util.i18n.BundleLookupThreadContext;
import com.aoindustries.util.i18n.EditableResourceBundleSet;
import com.aoindustries.util.i18n.LocaleComparator;
import com.aoindustries.util.i18n.MarkupType;
import com.aoindustries.util.i18n.ModifiablePropertiesResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public abstract class EditableResourceBundle
extends ModifiablePropertiesResourceBundle
implements Comparable<EditableResourceBundle> {
    public static final String VISIBILITY_COOKIE_NAME = "EditableResourceBundleEditorVisibility";
    public static final String EMPTY_DISPLAY = "[BLANK]";
    static final ThreadLocal<ThreadSettings> currentThreadSettings = new ThreadLocal<ThreadSettings>(){

        @Override
        protected ThreadSettings initialValue() {
            return new ThreadSettings(false, false, null);
        }
    };
    private final Locale locale;
    private final EditableResourceBundleSet bundleSet;

    public static void resetRequest(boolean canEditResources, String setValueUrl, boolean modifyAllText) {
        if (canEditResources) {
            if (setValueUrl == null) {
                throw new IllegalArgumentException("setValueUrl is null when canEditResources is true");
            }
            BundleLookupThreadContext.getThreadContext(true).reset();
        } else {
            BundleLookupThreadContext.removeThreadContext();
        }
        currentThreadSettings.set(new ThreadSettings(canEditResources, modifyAllText, setValueUrl));
    }

    private static String convertEmpty(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return EMPTY_DISPLAY;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printEditableResourceBundleLookups(Encoder textInJavaScriptEncoder, Encoder textInXhtmlEncoder, Appendable out, int editorRows, boolean verticalButtons) throws IOException {
        ThreadSettings threadSettings = currentThreadSettings.get();
        Map map = threadSettings.requestLookups;
        synchronized (map) {
            final Map lookups = threadSettings.requestLookups;
            String setValueUrl = threadSettings.setValueUrl;
            EditableResourceBundle.resetRequest(false, null, false);
            if (!lookups.isEmpty()) {
                ArrayList lookupKeys = new ArrayList(lookups.keySet());
                Collections.sort(lookupKeys, new Comparator<LookupKey>(){

                    @Override
                    public int compare(LookupKey key1, LookupKey key2) {
                        return Long.valueOf(((LookupValue)lookups.get(key1)).id).compareTo(((LookupValue)lookups.get(key2)).id);
                    }
                });
                if (setValueUrl != null) {
                    EditableResourceBundleSet bundleSet;
                    TreeSet<Locale> allLocales = new TreeSet<Locale>(LocaleComparator.getInstance());
                    for (LookupKey lookupKey : lookupKeys) {
                        allLocales.addAll(lookupKey.bundleSet.getLocales());
                    }
                    out.append("<div style='position:fixed; bottom:0px; left:50%; width:300px; margin-left:-150px; text-align:center'>\n");
                    int invalidatedCount = 0;
                    int missingCount = 0;
                    for (Object lookupValue : lookups.values()) {
                        for (LookupLocaleValue localeValue : ((LookupValue)lookupValue).locales.values()) {
                            if (localeValue.missing) {
                                ++missingCount;
                                continue;
                            }
                            if (!localeValue.invalidated) continue;
                            ++invalidatedCount;
                        }
                    }
                    out.append("  <a href=\"#\" onclick=\"if(EditableResourceBundleEditorSetVisibility) EditableResourceBundleEditorSetVisibility(document.getElementById('EditableResourceBundleEditor').style.visibility=='visible' ? 'hidden' : 'visible'); return false;\" style=\"text-decoration:none; color:black\"><span style='border:1px solid black; background-color:white'>").append(Integer.toString(lookups.size())).append(lookups.size() == 1 ? " Resource" : " Resources");
                    if (missingCount > 0) {
                        out.append(" | <span style='color:red'>").append(Integer.toString(missingCount)).append(" Missing</span>");
                    }
                    if (invalidatedCount > 0) {
                        out.append(" | <span style='color:blue'>").append(Integer.toString(invalidatedCount)).append(" Invalidated</span>");
                    }
                    out.append("</span></a>\n</div>\n<div id=\"EditableResourceBundleEditor\" style=\"position:fixed; left:50px; width:640px; top:50px; height:480px; visibility:hidden; border-left:1px solid black; border-top:1px solid black; border-right:2px solid black; border-bottom:2px solid black; background-color:white; overflow:hidden\">\n  <div style=\"border-top:1px solid black; background-color:#c0c0c0; position:absolute; left:0px; width:100%; bottom:0px; height:").append(Integer.toString(allLocales.size() * editorRows)).append("em; overflow:hidden\">\n");
                    int i = 0;
                    for (Locale locale : allLocales) {
                        String toString = locale.toString();
                        out.append("    <div style=\"position:absolute; left:0px; width:6em; top:").append(Integer.toString(i * editorRows)).append("em; height:").append(Integer.toString(editorRows)).append("em\">\n      <div style=\"position:absolute; top:50%; height:1em; margin-top:-.5em; padding-left:4px; padding-right:2px\">\n        ").append(toString.length() == 0 ? "Default" : toString).append("\n      </div>\n    </div>\n    <div style=\"position:absolute; left:6em; right:").append(verticalButtons ? "10em" : "14em").append("; top:").append(Integer.toString(i * editorRows)).append("em; height:").append(Integer.toString(editorRows)).append("em\">\n      <textarea disabled=\"disabled\" id=\"EditableResourceBundleEditorTextArea").append(Integer.toString(i + 1)).append("\" name=\"EditableResourceBundleEditorTextArea").append(Integer.toString(i + 1)).append("\" cols=\"40\" rows=\"").append(Integer.toString(editorRows)).append("\" style=\"width:100%; height:100%\"></textarea>\n    </div>\n    <div style=\"position:absolute; width:").append(verticalButtons ? "10em" : "14em").append("; right:0px; top:").append(Integer.toString(i * editorRows)).append("em; height:").append(Integer.toString(editorRows)).append("em\">\n");
                        if (verticalButtons) {
                            out.append("      <div style=\"position:absolute; left:0px; width:100%; top:30%; height:1.2em; margin-top:-.6em; text-align:center\">\n        <input disabled=\"disabled\" id=\"EditableResourceBundleEditorValidateButton").append(Integer.toString(i + 1)).append("\" name=\"EditableResourceBundleEditorValidateButton").append(Integer.toString(i + 1)).append("\" type=\"button\" value=\"Validate\" onclick=\"return EditableResourceBundleEditorModifyOnClick(").append(Integer.toString(i)).append(", false);\" />\n      </div>\n      <div style=\"position:absolute; left:0px; width:100%; top:70%; height:1.2em; margin-top:-.6em; text-align:center\">\n        <input disabled=\"disabled\" id=\"EditableResourceBundleEditorModifyButton").append(Integer.toString(i + 1)).append("\" name=\"EditableResourceBundleEditorModifyButton").append(Integer.toString(i + 1)).append("\" type=\"button\" value=\"Modify\" onclick=\"return EditableResourceBundleEditorModifyOnClick(").append(Integer.toString(i)).append(", true);\" />\n      </div>\n");
                        } else {
                            out.append("      <div style=\"position:absolute; left:0px; width:100%; top:50%; height:1.2em; margin-top:-.6em; text-align:center\">\n        <input disabled=\"disabled\" id=\"EditableResourceBundleEditorValidateButton").append(Integer.toString(i + 1)).append("\" name=\"EditableResourceBundleEditorValidateButton").append(Integer.toString(i + 1)).append("\" type=\"button\" value=\"Validate\" onclick=\"return EditableResourceBundleEditorModifyOnClick(").append(Integer.toString(i)).append(", false);\" />\n        <input disabled=\"disabled\" id=\"EditableResourceBundleEditorModifyButton").append(Integer.toString(i + 1)).append("\" name=\"EditableResourceBundleEditorModifyButton").append(Integer.toString(i + 1)).append("\" type=\"button\" value=\"Modify\" onclick=\"return EditableResourceBundleEditorModifyOnClick(").append(Integer.toString(i)).append(", true);\" />\n      </div>\n");
                        }
                        out.append("    </div>\n");
                        ++i;
                    }
                    out.append("  </div>\n  <div id=\"EditableResourceBundleEditorHeader\" style=\"border-bottom:1px solid black; background-color:#c0c0c0; position:absolute; left:0px; width:100%; top:0px; height:2em; overflow:hidden\">\n    <div style=\"float:right; border:2px outset black; margin:.3em\"><a href=\"#\" onclick=\"if(EditableResourceBundleEditorSetVisibility) EditableResourceBundleEditorSetVisibility('hidden'); return false;\" style=\"text-decoration:none; color:black; background-color:white; padding-left:2px; padding-right:2px;\">\u2715</a></div>\n    <script type='text/javascript'>\n      // <![CDATA[\n      function EditableResourceBundleEditorSetCookie(c_name,value,expiredays) {\n        var exdate=new Date();\n        exdate.setDate(exdate.getDate()+expiredays);\n        document.cookie=c_name+\"=\"+escape(value)+((expiredays==null)?\"\":\"; expires=\"+exdate.toGMTString())+\"; path=/\";\n      }\n\n      // From http://www.w3schools.com/JS/js_cookies.asp\n      function EditableResourceBundleEditorGetCookie(c_name) {\n        if (document.cookie.length>0) {\n          c_start=document.cookie.indexOf(c_name + \"=\");\n          if (c_start!=-1) {\n            c_start=c_start + c_name.length+1;\n            c_end=document.cookie.indexOf(\";\",c_start);\n            if (c_end==-1) c_end=document.cookie.length;\n              return unescape(document.cookie.substring(c_start,c_end));\n            }\n        }\n        return \"\";\n      }\n\n      function EditableResourceBundleEditorSetVisibility(visibility) {\n        document.getElementById('EditableResourceBundleEditor').style.visibility=visibility;\n        EditableResourceBundleEditorSetCookie(\"EditableResourceBundleEditorVisibility\", visibility, 31);\n      }\n\n      var EditableResourceBundleEditorRowValues=[");
                    boolean didOne1 = false;
                    for (LookupKey lookupKey : lookupKeys) {
                        bundleSet = lookupKey.bundleSet;
                        if (didOne1) {
                            out.append(',');
                        } else {
                            didOne1 = true;
                        }
                        out.append("\n        [");
                        boolean didOne2 = false;
                        for (Locale locale : allLocales) {
                            if (didOne2) {
                                out.append(',');
                            } else {
                                didOne2 = true;
                            }
                            if (bundleSet.getLocales().contains(locale)) {
                                out.append('\"');
                                String value = EditableResourceBundle.convertEmpty(bundleSet.getResourceBundle(locale).getValue(lookupKey.key));
                                textInJavaScriptEncoder.append(value, out);
                                out.append('\"');
                                continue;
                            }
                            out.append("null");
                        }
                        out.append(']');
                    }
                    out.append("\n  ];\n\n      var EditableResourceBundleEditorRowBaseNames=[");
                    didOne1 = false;
                    for (LookupKey lookupKey : lookupKeys) {
                        if (didOne1) {
                            out.append(',');
                        } else {
                            didOne1 = true;
                        }
                        out.append("\n        \"");
                        textInJavaScriptEncoder.append(lookupKey.bundleSet.getBaseName(), out);
                        out.append('\"');
                    }
                    out.append("\n  ];\n\n      var EditableResourceBundleEditorLocales=[");
                    didOne1 = false;
                    for (Locale locale : allLocales) {
                        if (didOne1) {
                            out.append(',');
                        } else {
                            didOne1 = true;
                        }
                        out.append("\n        \"");
                        textInJavaScriptEncoder.append(locale.toString(), out);
                        out.append('\"');
                    }
                    out.append("\n  ];\n\n      var EditableResourceBundleEditorRowKeys=[");
                    didOne1 = false;
                    for (LookupKey lookupKey : lookupKeys) {
                        if (didOne1) {
                            out.append(',');
                        } else {
                            didOne1 = true;
                        }
                        out.append("\n        \"");
                        textInJavaScriptEncoder.append(lookupKey.key, out);
                        out.append('\"');
                    }
                    out.append("\n  ];\n\n      var EditableResourceBundleEditorSelectedRow = null;\n      var EditableResourceBundleEditorSelectedIndex = -1;\n      function EditableResourceBundleEditorSelectedRowOnClick(index, row, originalBackground) {\n        row.EditableResourceBundleEditorSelectedRowOriginalBackground=originalBackground;\n        if(EditableResourceBundleEditorSelectedRow!=row) {\n          if(EditableResourceBundleEditorSelectedRow!=null) {\n            EditableResourceBundleEditorSelectedRow.style.backgroundColor=EditableResourceBundleEditorSelectedRow.EditableResourceBundleEditorSelectedRowOriginalBackground;\n          }\n          EditableResourceBundleEditorSelectedRow=row;\n          EditableResourceBundleEditorSelectedIndex=index;\n          var rowValues=EditableResourceBundleEditorRowValues[index];\n          for(var c=0; c<").append(Integer.toString(allLocales.size())).append("; c++) {\n            var value=rowValues[c];\n            var textArea=document.getElementById(\"EditableResourceBundleEditorTextArea\"+(c+1));\n            var validateButton=document.getElementById(\"EditableResourceBundleEditorValidateButton\"+(c+1));\n            var modifyButton=document.getElementById(\"EditableResourceBundleEditorModifyButton\"+(c+1));\n            if(value==null) {\n              textArea.disabled=true;\n              validateButton.disabled=true;\n              modifyButton.disabled=true;\n              textArea.value=\"\";\n            } else {\n              textArea.value=value;\n              textArea.disabled=false;\n              validateButton.disabled=false;\n              modifyButton.disabled=false;\n            }\n          }\n        }\n        row.style.backgroundColor=\"red\";\n      }\n\n      function EditableResourceBundleEditorUpdateElements(rowIndex, value) {\n        var elementIds = EditableResourceBundleElementIds[rowIndex];\n        for(var e=0; e<elementIds.length; e++) {\n          elem=document.getElementById(\"EditableResourceBundleElement\"+elementIds[e]);\n          if(elem!=null) {\n            elem.innerHTML=value;\n          }\n        }\n      }\n\n      function EditableResourceBundleEditorModifyOnClick(localeIndex, modified) {\n        if(EditableResourceBundleEditorSelectedIndex!=null) {\n          var textArea=document.getElementById(\"EditableResourceBundleEditorTextArea\"+(localeIndex+1));\n          var value=textArea.value;\n          var request=new XMLHttpRequest();\n          var url=\"").append(setValueUrl).append("?baseName=\"+encodeURIComponent(EditableResourceBundleEditorRowBaseNames[EditableResourceBundleEditorSelectedIndex])+\"&locale=\"+encodeURIComponent(EditableResourceBundleEditorLocales[localeIndex])+\"&key=\"+encodeURIComponent(EditableResourceBundleEditorRowKeys[EditableResourceBundleEditorSelectedIndex])+\"&value=\"+encodeURIComponent(value)+\"&modified=\"+modified;\n          request.open('GET', url, false);\n          request.send(null);\n          if(request.status!=200) {\n            window.alert(\"Update failed: \"+request.status+\" from \"+url);\n          } else {\n            EditableResourceBundleEditorRowValues[EditableResourceBundleEditorSelectedIndex][localeIndex]=value;\n            var rowLocaleElem=document.getElementById(\"EditableResourceBundleEditorRow\"+(EditableResourceBundleEditorSelectedIndex+1)+\"Locale\"+(localeIndex+1));\n            if(rowLocaleElem==null) window.alert(\"rowLocaleElem is null\");\n            else {\n              var rowValue=(value.length>30) ? value.substring(0, 30)+\"\\u2026\" : value;\n              if(rowLocaleElem.firstChild==null) rowLocaleElem.appendChild(document.createTextNode(rowValue));\n              else rowLocaleElem.firstChild.nodeValue=rowValue;\n              if(!modified) rowLocaleElem.style.backgroundColor=\"white\";\n            }\n            if(modified) {\n              for(var c=0;c<").append(Integer.toString(allLocales.size())).append(";c++) {\n                rowLocaleElem=document.getElementById(\"EditableResourceBundleEditorRow\"+(EditableResourceBundleEditorSelectedIndex+1)+\"Locale\"+(c+1));\n                if(rowLocaleElem!=null) rowLocaleElem.style.backgroundColor=c==localeIndex ? \"#c0ffc0\" : \"#c0c0ff\";\n              }\n            }\n            EditableResourceBundleEditorUpdateElements(EditableResourceBundleEditorSelectedIndex, value);\n          }\n        }\n        return false;\n      }\n\n      var EditableResourceBundleEditorDragElem=null;\n      var EditableResourceBundleEditorResizeElem=null;\n      var EditableResourceBundleEditorDownScreenX;\n      var EditableResourceBundleEditorDownScreenY;\n      var EditableResourceBundleEditorDownElemX;\n      var EditableResourceBundleEditorDownElemY;\n      var EditableResourceBundleEditorDownElemWidth;\n      var EditableResourceBundleEditorDownElemHeight;\n\n      function EditableResourceBundleEditorDragMouseMove(event) {\n        if(EditableResourceBundleEditorDragElem!=null) {\n          var editorStyle=document.getElementById('EditableResourceBundleEditor').style;          editorStyle.left=(EditableResourceBundleEditorDownElemX+event.screenX-EditableResourceBundleEditorDownScreenX)+'px';\n          editorStyle.top=(EditableResourceBundleEditorDownElemY+event.screenY-EditableResourceBundleEditorDownScreenY)+'px';\n          EditableResourceBundleEditorSetCookie(\"EditableResourceBundleEditorLeft\", editorStyle.left, 31);\n          EditableResourceBundleEditorSetCookie(\"EditableResourceBundleEditorTop\", editorStyle.top, 31);\n          event.preventDefault();\n          return false;\n        }\n      }\n\n      function EditableResourceBundleEditorDragMouseUp(event) {\n        if(EditableResourceBundleEditorDragElem!=null) EditableResourceBundleEditorDragElem.style.cursor='auto';\n        EditableResourceBundleEditorDragElem=null;\n        document.removeEventListener('mousemove', EditableResourceBundleEditorDragMouseMove, true);\n        document.removeEventListener('mouseup', EditableResourceBundleEditorDragMouseUp, true);\n        document.getElementById('EditableResourceBundleEditorHeader').style.backgroundColor='#c0c0c0';\n        event.preventDefault();\n        return false;\n      }\n\n      function EditableResourceBundleEditorDragMouseDown(elem, event) {\n        EditableResourceBundleEditorDragElem=elem;\n        EditableResourceBundleEditorDownScreenX=event.screenX;\n        EditableResourceBundleEditorDownScreenY=event.screenY;\n        EditableResourceBundleEditorDownElemX=parseInt(document.getElementById('EditableResourceBundleEditor').style.left);\n        EditableResourceBundleEditorDownElemY=parseInt(document.getElementById('EditableResourceBundleEditor').style.top);\n        document.addEventListener('mousemove', EditableResourceBundleEditorDragMouseMove, true);\n        document.addEventListener('mouseup', EditableResourceBundleEditorDragMouseUp, true);\n        elem.style.cursor='move';\n        document.getElementById('EditableResourceBundleEditorHeader').style.backgroundColor=\"red\";\n        event.preventDefault();\n        return false;\n      }\n\n      function EditableResourceBundleEditorResizeMouseMove(event) {\n        if(EditableResourceBundleEditorResizeElem!=null) {\n          var editorStyle=document.getElementById('EditableResourceBundleEditor').style;          editorStyle.width=Math.max(100, EditableResourceBundleEditorDownElemWidth+event.screenX-EditableResourceBundleEditorDownScreenX)+'px';\n          editorStyle.height=Math.max(100, EditableResourceBundleEditorDownElemHeight+event.screenY-EditableResourceBundleEditorDownScreenY)+'px';\n          EditableResourceBundleEditorSetCookie(\"EditableResourceBundleEditorWidth\", editorStyle.width, 31);\n          EditableResourceBundleEditorSetCookie(\"EditableResourceBundleEditorHeight\", editorStyle.height, 31);\n          event.preventDefault();\n          return false;\n        }\n      }\n\n      function EditableResourceBundleEditorResizeMouseUp(event) {\n        EditableResourceBundleEditorResizeElem=null;\n        document.removeEventListener('mousemove', EditableResourceBundleEditorResizeMouseMove, true);\n        document.removeEventListener('mouseup', EditableResourceBundleEditorResizeMouseUp, true);\n        document.getElementById('EditableResourceBundleEditor').style.borderColor='black black black black';\n        event.preventDefault();\n        return false;\n      }\n\n      function EditableResourceBundleEditorResizeMouseDown(elem, event) {\n        EditableResourceBundleEditorResizeElem=elem;\n        EditableResourceBundleEditorDownScreenX=event.screenX;\n        EditableResourceBundleEditorDownScreenY=event.screenY;\n        EditableResourceBundleEditorDownElemWidth=parseInt(document.getElementById('EditableResourceBundleEditor').style.width);\n        EditableResourceBundleEditorDownElemHeight=parseInt(document.getElementById('EditableResourceBundleEditor').style.height);\n        document.addEventListener('mousemove', EditableResourceBundleEditorResizeMouseMove, true);\n        document.addEventListener('mouseup', EditableResourceBundleEditorResizeMouseUp, true);\n        document.getElementById('EditableResourceBundleEditor').style.borderColor='red red red red';\n        event.preventDefault();\n        return false;\n      }\n      // ]]>\n    </script>\n    <div style=\"text-align:center; font-weight:bold; font-size:larger\" onmousedown=\"return EditableResourceBundleEditorDragMouseDown(this, event);\">Resource Editor</div>\n  </div>\n  <div id=\"EditableResourceBundleEditorScroller\" style=\"position:absolute; left:0px; width:100%; top:2em; bottom:").append(Integer.toString(allLocales.size() * editorRows)).append("em; overflow:auto\">\n    <table style=\"width:100%; border-collapse: collapse; border:1px solid black\">\n      <tr style=\"background-color:#e0e0e0\">\n        <th style=\"border:1px solid black\"></th>\n        <th style=\"border:1px solid black\">Key</th>\n");
                    for (Locale locale : allLocales) {
                        String toString = locale.toString();
                        out.append("        <th style=\"border:1px solid black\">").append(toString.length() == 0 ? "Default" : toString).append("</th>\n");
                    }
                    out.append("        <th style=\"border:1px solid black\">Bundle Set</th>\n      </tr>\n");
                    i = 0;
                    for (LookupKey lookupKey : lookupKeys) {
                        bundleSet = lookupKey.bundleSet;
                        LookupValue lookupValue = (LookupValue)lookups.get(lookupKey);
                        List elementIds = lookupValue.elementIds;
                        String key = lookupKey.key;
                        String lookupId = Long.toString(lookupValue.id);
                        out.append("      <tr id=\"EditableResourceBundleEditorRow").append(lookupId).append("\" style=\"background-color:").append((++i & 1) == 1 ? "white" : "#e0e0e0").append('\"');
                        if (!elementIds.isEmpty()) {
                            out.append(" onmouseover=\"if(typeof EditableResourceBundleHighlightAll == &#39;function&#39;) EditableResourceBundleHighlightAll(").append(((Long)elementIds.get(0)).toString()).append(", false);\" onmouseout=\"if(typeof EditableResourceBundleUnhighlightAll == &#39;function&#39;) EditableResourceBundleUnhighlightAll(").append(((Long)elementIds.get(0)).toString()).append(");\"");
                        }
                        out.append(">\n        <td onclick=\"EditableResourceBundleEditorSelectedRowOnClick(").append(Integer.toString(i - 1)).append(", document.getElementById('EditableResourceBundleEditorRow").append(lookupId).append("'), '").append((i & 1) == 1 ? "white" : "#e0e0e0").append("');\" style=\"text-align:right; border:1px solid black\">").append(Long.toString(lookupValue.id)).append("</td>\n        <td onclick=\"EditableResourceBundleEditorSelectedRowOnClick(").append(Integer.toString(i - 1)).append(", document.getElementById('EditableResourceBundleEditorRow").append(lookupId).append("'), '").append((i & 1) == 1 ? "white" : "#e0e0e0").append("');\" style=\"border:1px solid black\">");
                        textInXhtmlEncoder.append(lookupKey.key, out);
                        out.append("</td>\n");
                        int localeIndex = 0;
                        for (Locale locale : allLocales) {
                            ++localeIndex;
                            if (bundleSet.getLocales().contains(locale)) {
                                String backgroundColor;
                                EditableResourceBundle localeBundle;
                                String currentValue;
                                LookupLocaleValue localeValue = (LookupLocaleValue)lookupValue.locales.get(locale);
                                String borderColor = null;
                                if (localeValue != null) {
                                    borderColor = localeValue.missing ? "red" : (localeValue.invalidated ? "blue" : "black");
                                }
                                if ((currentValue = EditableResourceBundle.convertEmpty((localeBundle = bundleSet.getResourceBundle(locale)).getValue(key))) == null) {
                                    backgroundColor = "#ffc0c0";
                                } else {
                                    Long validatedTime;
                                    Long newestModifiedTime = null;
                                    for (Locale possLocale : bundleSet.getLocales()) {
                                        EditableResourceBundle possBundle = bundleSet.getResourceBundle(possLocale);
                                        Long possModifiedTime = possBundle.getModifiedTime(key);
                                        if (possModifiedTime == null || newestModifiedTime != null && possModifiedTime <= newestModifiedTime) continue;
                                        newestModifiedTime = possModifiedTime;
                                    }
                                    Long modifiedTime = localeBundle.getModifiedTime(key);
                                    backgroundColor = modifiedTime != null && modifiedTime.equals(newestModifiedTime) ? "#c0ffc0" : ((validatedTime = localeBundle.getValidatedTime(key)) == null ? (newestModifiedTime == null ? "white" : "#c0c0ff") : (newestModifiedTime == null ? "white" : (validatedTime < newestModifiedTime ? "#c0c0ff" : "white")));
                                }
                                out.append("        <td id=\"EditableResourceBundleEditorRow").append(Integer.toString(i)).append("Locale").append(Integer.toString(localeIndex)).append("\" style=\"white-space:pre; ");
                                if (borderColor != null) {
                                    out.append("border:2px solid ").append(borderColor).append("; ");
                                } else {
                                    out.append("border:1px solid black; ");
                                }
                                out.append("background-color:").append(backgroundColor).append("\" onclick=\"EditableResourceBundleEditorSelectedRowOnClick(").append(Integer.toString(i - 1)).append(", document.getElementById('EditableResourceBundleEditorRow").append(lookupId).append("'), '").append((i & 1) == 1 ? "white" : "#e0e0e0").append("'); document.getElementById('EditableResourceBundleEditorTextArea").append(Integer.toString(localeIndex)).append("').select(); document.getElementById('EditableResourceBundleEditorTextArea").append(Integer.toString(localeIndex)).append("').focus();\">");
                                if (currentValue != null) {
                                    if (currentValue.length() > 30) {
                                        textInXhtmlEncoder.append(currentValue, 0, 30, out);
                                        out.append("\u2026");
                                    } else {
                                        textInXhtmlEncoder.append(currentValue, out);
                                    }
                                }
                                out.append("</td>\n");
                                continue;
                            }
                            out.append("        <td style=\"opacity:.5; background-color:#404040; border:1px solid black\"></td>\n");
                        }
                        out.append("        <td onclick=\"EditableResourceBundleEditorSelectedRowOnClick(").append(Integer.toString(i - 1)).append(", document.getElementById('EditableResourceBundleEditorRow").append(lookupId).append("'), '").append((i & 1) == 1 ? "white" : "#e0e0e0").append("');\">");
                        textInXhtmlEncoder.append(bundleSet.getBaseName(), out);
                        out.append("</td>\n      </tr>\n");
                    }
                    out.append("    </table>\n  </div>\n  <div style=\"position:absolute; right:0px; width:20px; bottom:0px; height:20px; overflow:hidden; cursor:nw-resize\" onmousedown=\"return EditableResourceBundleEditorResizeMouseDown(this, event);\"></div>\n</div>\n");
                }
                out.append("<script type='text/javascript'>\n  // <![CDATA[\n\n  // Restore the editor to its previous position\n  var EditableResourceBundleEditorStyle=document.getElementById(\"EditableResourceBundleEditor\").style;\n  var EditableResourceBundleEditorWidth = EditableResourceBundleEditorGetCookie(\"EditableResourceBundleEditorWidth\");\n  if(EditableResourceBundleEditorWidth!=\"\") EditableResourceBundleEditorStyle.width=EditableResourceBundleEditorWidth;\n  var EditableResourceBundleEditorHeight = EditableResourceBundleEditorGetCookie(\"EditableResourceBundleEditorHeight\");\n  if(EditableResourceBundleEditorHeight!=\"\") EditableResourceBundleEditorStyle.height=EditableResourceBundleEditorHeight;\n  var EditableResourceBundleEditorTop = EditableResourceBundleEditorGetCookie(\"EditableResourceBundleEditorTop\");\n  if(EditableResourceBundleEditorTop!=\"\" && parseInt(EditableResourceBundleEditorTop)>=0 && (parseInt(EditableResourceBundleEditorTop)+parseInt(EditableResourceBundleEditorStyle.height))<=window.innerHeight) EditableResourceBundleEditorStyle.top=EditableResourceBundleEditorTop;\n  var EditableResourceBundleEditorLeft = EditableResourceBundleEditorGetCookie(\"EditableResourceBundleEditorLeft\");\n  if(EditableResourceBundleEditorLeft!=\"\" && parseInt(EditableResourceBundleEditorLeft)>=0 && (parseInt(EditableResourceBundleEditorLeft)+parseInt(EditableResourceBundleEditorStyle.width))<=window.innerWidth) EditableResourceBundleEditorStyle.left=EditableResourceBundleEditorLeft;\n  var EditableResourceBundleEditorVisibility = EditableResourceBundleEditorGetCookie(\"EditableResourceBundleEditorVisibility\");\n  if(EditableResourceBundleEditorVisibility!=\"\") EditableResourceBundleEditorStyle.visibility=EditableResourceBundleEditorVisibility;\n\n  var EditableResourceBundleLookupIds=[");
                boolean didOne1 = false;
                for (LookupKey lookupKey : lookupKeys) {
                    LookupValue lookupValue = (LookupValue)lookups.get(lookupKey);
                    if (didOne1) {
                        out.append(',');
                    } else {
                        didOne1 = true;
                    }
                    out.append("\n    ").append(Long.toString(lookupValue.id));
                }
                out.append("\n  ];\n\n  var EditableResourceBundleElementIds=[");
                didOne1 = false;
                for (LookupKey lookupKey : lookupKeys) {
                    LookupValue lookupValue = (LookupValue)lookups.get(lookupKey);
                    if (didOne1) {
                        out.append(',');
                    } else {
                        didOne1 = true;
                    }
                    out.append("\n    [");
                    boolean didOne2 = false;
                    for (Long id : lookupValue.elementIds) {
                        if (didOne2) {
                            out.append(',');
                        } else {
                            didOne2 = true;
                        }
                        out.append(id.toString());
                    }
                    out.append(']');
                }
                out.append("\n  ];\n\n  var EditableResourceBundleDelayScrollElement = null;\n  var EditableResourceBundleDelayScrollTimerId = null;\n\n  function EditableResourceBundleDelayDoScroll() {\n    var scroller=document.getElementById(\"EditableResourceBundleEditorScroller\");\n    scroller.scrollTop=EditableResourceBundleDelayScrollElement.offsetTop-(scroller.clientHeight-EditableResourceBundleDelayScrollElement.offsetHeight)/2;\n    clearTimeout(EditableResourceBundleDelayScrollTimerId);\n  }\n\n  function EditableResourceBundleDelayScroll(elem) {\n    EditableResourceBundleDelayScrollElement=elem;\n    EditableResourceBundleDelayScrollTimerId=setTimeout(\"EditableResourceBundleDelayDoScroll()\", 250);\n  }\n\n  function EditableResourceBundleCancelDelayScroll() {\n    clearTimeout(EditableResourceBundleDelayScrollTimerId);\n  }\n\n  function EditableResourceBundleSetAllBackgrounds(elementId, background, scrollEditor) {\n    for(var c=0; c<EditableResourceBundleElementIds.length; c++) {\n      var elementIds = EditableResourceBundleElementIds[c];\n      for(var d=0; d<elementIds.length; d++) {\n        if(elementId==elementIds[d]) {\n          var elem=document.getElementById(\"EditableResourceBundleEditorRow\"+EditableResourceBundleLookupIds[c]);\n          if(elem!=null) {\n            elem.style.backgroundColor=elem==(!scrollEditor && EditableResourceBundleEditorSelectedRow) ? \"red\" : background!=\"transparent\" ? background : elem==EditableResourceBundleEditorSelectedRow ? \"red\" : (c&1)==0 ? \"white\" : \"#e0e0e0\";\n            if(scrollEditor) {\n              EditableResourceBundleDelayScroll(elem);\n            }\n          }\n          for(var e=0; e<elementIds.length; e++) {\n            elem=document.getElementById(\"EditableResourceBundleElement\"+elementIds[e]);\n            if(elem!=null) elem.style.backgroundColor=background;\n          }\n          return;\n        }\n      }\n    }\n  }\n\n  function EditableResourceBundleHighlightAll(elementId, scrollEditor) {\n    EditableResourceBundleSetAllBackgrounds(elementId, \"yellow\", scrollEditor);\n  }\n\n  function EditableResourceBundleUnhighlightAll(elementId) {\n    EditableResourceBundleCancelDelayScroll();\n    EditableResourceBundleSetAllBackgrounds(elementId, \"transparent\", false);\n  }\n  // ]]>\n</script>\n");
            }
        }
    }

    public EditableResourceBundle(Locale locale, EditableResourceBundleSet bundleSet, File ... sourceFiles) {
        super(sourceFiles);
        this.locale = locale;
        this.bundleSet = bundleSet;
        bundleSet.addBundle(this);
    }

    Locale getBundleLocale() {
        return this.locale;
    }

    EditableResourceBundleSet getBundleSet() {
        return this.bundleSet;
    }

    @Override
    public int compareTo(EditableResourceBundle o) {
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handleGetObject(String key) {
        ThreadSettings threadSettings = currentThreadSettings.get();
        Object object = super.handleGetObject(key);
        if (!this.isModifiable() || !threadSettings.canEditResources) {
            return object;
        }
        String value = (String)object;
        Long newestModifiedTime = null;
        for (Locale possLocale : this.bundleSet.getLocales()) {
            EditableResourceBundle possBundle = this.bundleSet.getResourceBundle(possLocale);
            Long possModifiedTime = possBundle.getModifiedTime(key);
            if (possModifiedTime == null || newestModifiedTime != null && possModifiedTime <= newestModifiedTime) continue;
            newestModifiedTime = possModifiedTime;
        }
        Long validatedTime = this.bundleSet.getResourceBundle(this.locale).getValidatedTime(key);
        boolean invalidated = newestModifiedTime == null ? false : (validatedTime == null ? true : validatedTime < newestModifiedTime);
        Map map = threadSettings.requestLookups;
        synchronized (map) {
            BundleLookupThreadContext threadContext;
            LookupKey lookupKey = new LookupKey(this.bundleSet, key);
            LookupValue lookupValue = (LookupValue)threadSettings.requestLookups.get(lookupKey);
            if (lookupValue == null) {
                lookupValue = new LookupValue(threadSettings);
                threadSettings.requestLookups.put(lookupKey, lookupValue);
            }
            if (!lookupValue.locales.containsKey(this.locale)) {
                lookupValue.locales.put(this.locale, new LookupLocaleValue(value == null, invalidated));
            }
            if (value != null && (threadContext = BundleLookupThreadContext.getThreadContext(false)) != null) {
                long elementId = threadSettings.elementIdGenerator.getNextSequenceValue();
                lookupValue.elementIds.add(elementId);
                if (threadContext.getLookupMarkup(value) != null) {
                    value = new String(value);
                }
                threadContext.addLookupMarkup(value, new EditableResourceBundleLookupMarkup(lookupValue.id, invalidated, elementId, threadSettings.modifyAllText));
            }
        }
        return value;
    }

    private static final class EditableResourceBundleLookupMarkup
    implements BundleLookupMarkup {
        private final long lookupId;
        private final boolean invalidated;
        private final long elementId;
        private final boolean modifyAllText;

        private EditableResourceBundleLookupMarkup(long lookupId, boolean invalidated, long elementId, boolean modifyAllText) {
            this.lookupId = lookupId;
            this.invalidated = invalidated;
            this.elementId = elementId;
            this.modifyAllText = modifyAllText;
        }

        @Override
        public void appendPrefixTo(MarkupType markupType, Appendable out) throws IOException {
            switch (markupType) {
                case NONE: {
                    break;
                }
                case XHTML: {
                    String elementIdString = Long.toString(this.elementId);
                    out.append("<!--").append(Long.toString(this.lookupId)).append("--><span id=\"EditableResourceBundleElement").append(elementIdString).append("\" onmouseover=\"if(typeof EditableResourceBundleHighlightAll == &#39;function&#39;) EditableResourceBundleHighlightAll(").append(elementIdString).append(", true);\"").append(" onmouseout=\"if(typeof EditableResourceBundleUnhighlightAll == &#39;function&#39;) EditableResourceBundleUnhighlightAll(").append(elementIdString).append(");\">");
                    break;
                }
                case TEXT: {
                    if (this.invalidated) {
                        out.append("<<<").append(Long.toString(this.lookupId)).append('<');
                        break;
                    }
                    if (!this.modifyAllText) break;
                    out.append('<').append(Long.toString(this.lookupId)).append('<');
                    break;
                }
                case JAVASCRIPT: {
                    out.append("/*").append(Long.toString(this.lookupId)).append("*/");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public void appendPrefixTo(MarkupType markupType, Encoder encoder, Appendable out) throws IOException {
            if (encoder == null) {
                this.appendPrefixTo(markupType, out);
            } else {
                switch (markupType) {
                    case NONE: {
                        break;
                    }
                    case XHTML: {
                        String elementIdString = Long.toString(this.elementId);
                        encoder.append("<!--", out).append(Long.toString(this.lookupId), out).append("--><span id=\"EditableResourceBundleElement", out).append(elementIdString, out).append("\" onmouseover=\"if(typeof EditableResourceBundleHighlightAll == &#39;function&#39;) EditableResourceBundleHighlightAll(", out).append(elementIdString, out).append(", true);\"", out).append(" onmouseout=\"if(typeof EditableResourceBundleUnhighlightAll == &#39;function&#39;) EditableResourceBundleUnhighlightAll(", out).append(elementIdString, out).append(");\">", out);
                        break;
                    }
                    case TEXT: {
                        if (this.invalidated) {
                            encoder.append("<<<", out).append(Long.toString(this.lookupId), out).append('<', out);
                            break;
                        }
                        if (!this.modifyAllText) break;
                        encoder.append('<', out).append(Long.toString(this.lookupId), out).append('<', out);
                        break;
                    }
                    case JAVASCRIPT: {
                        encoder.append("/*", out).append(Long.toString(this.lookupId), out).append("*/", out);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        @Override
        public void appendSuffixTo(MarkupType markupType, Appendable out) throws IOException {
            switch (markupType) {
                case NONE: {
                    break;
                }
                case XHTML: {
                    out.append("</span>");
                    break;
                }
                case TEXT: {
                    if (this.invalidated) {
                        out.append('>').append(Long.toString(this.lookupId)).append(">>>");
                        break;
                    }
                    if (!this.modifyAllText) break;
                    out.append('>').append(Long.toString(this.lookupId)).append('>');
                    break;
                }
                case JAVASCRIPT: {
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public void appendSuffixTo(MarkupType markupType, Encoder encoder, Appendable out) throws IOException {
            if (encoder == null) {
                this.appendSuffixTo(markupType, out);
            } else {
                switch (markupType) {
                    case NONE: {
                        break;
                    }
                    case XHTML: {
                        encoder.append("</span>", out);
                        break;
                    }
                    case TEXT: {
                        if (this.invalidated) {
                            encoder.append('>', out).append(Long.toString(this.lookupId), out).append(">>>", out);
                            break;
                        }
                        if (!this.modifyAllText) break;
                        encoder.append('>', out).append(Long.toString(this.lookupId), out).append('>', out);
                        break;
                    }
                    case JAVASCRIPT: {
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    private static class LookupValue {
        private final long id;
        private final List<Long> elementIds = new ArrayList<Long>();
        private final Map<Locale, LookupLocaleValue> locales = new HashMap<Locale, LookupLocaleValue>();

        private LookupValue(ThreadSettings threadSettings) {
            assert (Thread.holdsLock(threadSettings.requestLookups));
            this.id = threadSettings.lookupIdGenerator.getNextSequenceValue();
        }
    }

    private static class LookupLocaleValue {
        private final boolean missing;
        private final boolean invalidated;

        private LookupLocaleValue(boolean missing, boolean invalidated) {
            this.missing = missing;
            this.invalidated = invalidated;
        }
    }

    private static class LookupKey {
        private final EditableResourceBundleSet bundleSet;
        private final String key;

        private LookupKey(EditableResourceBundleSet bundleSet, String key) {
            this.bundleSet = bundleSet;
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LookupKey)) {
                return false;
            }
            LookupKey other = (LookupKey)obj;
            return this.bundleSet == other.bundleSet && this.key.equals(other.key);
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + this.bundleSet.hashCode();
            hash = 97 * hash + this.key.hashCode();
            return hash;
        }
    }

    private static class ThreadSettings {
        private final boolean canEditResources;
        private final boolean modifyAllText;
        private final Sequence elementIdGenerator = new UnsynchronizedSequence();
        private final Sequence lookupIdGenerator = new UnsynchronizedSequence();
        private final Map<LookupKey, LookupValue> requestLookups = new HashMap<LookupKey, LookupValue>();
        private final String setValueUrl;

        ThreadSettings(boolean canEditResources, boolean modifyAllText, String setValueUrl) {
            this.canEditResources = canEditResources;
            this.modifyAllText = modifyAllText;
            this.setValueUrl = setValueUrl;
        }
    }
}

