/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.i18n;

import com.aoindustries.text.MessageFormatFactory;
import com.aoindustries.util.i18n.BundleLookupMarkup;
import com.aoindustries.util.i18n.BundleLookupThreadContext;
import com.aoindustries.util.i18n.ThreadLocale;
import java.io.Serializable;
import java.text.FieldPosition;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ApplicationResourcesAccessor
implements Serializable {
    private static final long serialVersionUID = -8735217773587095120L;
    private static final ConcurrentMap<String, ApplicationResourcesAccessor> accessors = new ConcurrentHashMap<String, ApplicationResourcesAccessor>();
    private final String baseName;

    public static ApplicationResourcesAccessor getInstance(String baseName) {
        ApplicationResourcesAccessor newAccessor;
        ApplicationResourcesAccessor existing = (ApplicationResourcesAccessor)accessors.get(baseName);
        if (existing == null && (existing = accessors.putIfAbsent(baseName, newAccessor = new ApplicationResourcesAccessor(baseName))) == null) {
            existing = newAccessor;
        }
        return existing;
    }

    private ApplicationResourcesAccessor(String baseName) {
        this.baseName = baseName;
    }

    private Object readResolve() {
        return ApplicationResourcesAccessor.getInstance(this.baseName);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(this.baseName, locale);
    }

    public String getMessage(String key) {
        return this.getMessage(ThreadLocale.get(), key);
    }

    public String getMessage(Locale locale, String key) {
        String string = null;
        try {
            string = this.getResourceBundle(locale).getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string == null) {
            return "???" + locale.toString() + "." + key + "???";
        }
        return string;
    }

    public String getMessage(String key, Object ... args) {
        return this.getMessage(ThreadLocale.get(), key, args);
    }

    public String getMessage(Locale locale, String key, Object ... args) {
        String string = null;
        try {
            string = this.getResourceBundle(locale).getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (string == null) {
            return "???" + locale.toString() + "." + key + "???";
        }
        if (args.length == 0) {
            return string;
        }
        String newString = MessageFormatFactory.getMessageFormat(string, locale).format(args, new StringBuffer(string.length() << 1), (FieldPosition)null).toString();
        BundleLookupThreadContext threadContext = BundleLookupThreadContext.getThreadContext(false);
        if (threadContext != null) {
            BundleLookupMarkup lookupMarkup = threadContext.getLookupMarkup(string);
            threadContext.addLookupMarkup(newString, lookupMarkup);
        }
        return newString;
    }
}

