/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util.graph;

import com.aoindustries.util.AoCollections;
import com.aoindustries.util.graph.AsymmetricException;
import com.aoindustries.util.graph.CycleException;
import com.aoindustries.util.graph.Edge;
import com.aoindustries.util.graph.GraphChecker;
import com.aoindustries.util.graph.SymmetricMultiGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SymmetricAcyclicGraphChecker<V, EX extends Exception>
implements GraphChecker<EX> {
    private final SymmetricMultiGraph<V, ?, ? extends EX> graph;
    private final boolean isForward;

    public SymmetricAcyclicGraphChecker(SymmetricMultiGraph<V, ?, ? extends EX> graph, boolean isForward) {
        this.graph = graph;
        this.isForward = isForward;
    }

    @Override
    public void checkGraph() throws AsymmetricException, CycleException, EX {
        Set vertices = this.graph.getVertices();
        HashMap colors = new HashMap(vertices.size() * 4 / 3 + 1);
        HashMap predecessors = new HashMap();
        for (Object v : vertices) {
            if (colors.containsKey(v)) continue;
            this.doCheck(colors, predecessors, v);
        }
    }

    private void doCheck(Map<V, Color> colors, Map<V, V> predecessors, V vertex) throws AsymmetricException, CycleException, EX {
        colors.put((Color)((Object)vertex), Color.GRAY);
        for (Edge edge : this.isForward ? this.graph.getEdgesFrom(vertex) : this.graph.getEdgesTo(vertex)) {
            Object connected;
            Object v = connected = this.isForward ? edge.getTo() : edge.getFrom();
            if (!(!this.isForward ? this.graph.getEdgesFrom(connected).contains(new Edge(connected, vertex)) : this.graph.getEdgesTo(connected).contains(new Edge<V>(vertex, connected)))) {
                throw new AsymmetricException(vertex, connected);
            }
            Color uMark = colors.get(connected);
            if (Color.GRAY == uMark) {
                ArrayList<V> vertices = new ArrayList<V>();
                vertices.add(connected);
                V pred = vertex;
                while (pred != null) {
                    vertices.add(pred);
                    pred = pred.equals(connected) ? null : predecessors.get(pred);
                }
                throw new CycleException(AoCollections.optimalUnmodifiableList(vertices));
            }
            if (uMark != null) continue;
            predecessors.put(connected, vertex);
            this.doCheck(colors, predecessors, connected);
        }
        predecessors.remove(vertex);
        colors.put((Color)((Object)vertex), Color.BLACK);
    }

    private static enum Color {
        WHITE,
        GRAY,
        BLACK;

    }
}

