/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class UnionSet<E>
extends AbstractSet<E> {
    private static final int MAXIMUM_COMBINE_SIZE = 10;
    private Set<E> combined;
    private final List<Set<? extends E>> added = new ArrayList<Set<? extends E>>();

    public UnionSet() {
    }

    public UnionSet(Collection<? extends E> c) {
        this.combined = new HashSet(c.size() * 4 / 3 + 1);
        this.addAll(c);
    }

    public UnionSet(Set<? extends E> set) {
        this.addAll(set);
    }

    private void combine() {
        if (!this.added.isEmpty()) {
            if (this.combined == null) {
                int totalSize = 0;
                for (Set<E> set : this.added) {
                    totalSize += set.size();
                }
                this.combined = new HashSet(totalSize * 4 / 3 + 1);
            }
            for (Set<? extends E> set : this.added) {
                this.combined.addAll(set);
            }
            this.added.clear();
        }
    }

    @Override
    public int size() {
        this.combine();
        return this.combined == null ? 0 : this.combined.size();
    }

    @Override
    public boolean isEmpty() {
        return (this.combined == null || this.combined.isEmpty()) && this.added.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.combined != null && this.combined.contains(o)) {
            return true;
        }
        for (Set<E> set : this.added) {
            if (!set.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        this.combine();
        if (this.combined == null) {
            Set emptySet = Collections.emptySet();
            return emptySet.iterator();
        }
        return this.combined.iterator();
    }

    @Override
    public Object[] toArray() {
        this.combine();
        if (this.combined == null) {
            Set emptySet = Collections.emptySet();
            return emptySet.toArray();
        }
        return this.combined.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.combine();
        if (this.combined == null) {
            Set<T> emptySet = Collections.emptySet();
            return emptySet.toArray(a);
        }
        return this.combined.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (this.combined == null) {
            this.combined = new HashSet();
        }
        return this.combined.add(e);
    }

    @Override
    public boolean remove(Object o) {
        this.combine();
        return this.combined != null && this.combined.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        this.combine();
        if (this.combined == null) {
            this.combined = new HashSet<E>(c);
            return true;
        }
        return this.combined.addAll(c);
    }

    public void addAll(Set<? extends E> set) {
        if (set.size() <= 10) {
            if (this.combined == null) {
                this.combined = new HashSet<E>(set);
            } else {
                this.combined.addAll(set);
            }
        } else {
            this.added.add(set);
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.combine();
        if (this.combined == null) {
            this.combined = new HashSet();
        }
        return this.combined.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.combine();
        if (this.combined == null) {
            this.combined = new HashSet();
        }
        return this.combined.removeAll(c);
    }

    @Override
    public void clear() {
        if (this.combined != null) {
            this.combined.clear();
        }
        this.added.clear();
    }
}

