/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.util.LongArrayList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class SortedLongArrayList
extends LongArrayList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2587216177946775702L;

    public SortedLongArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedLongArrayList() {
    }

    protected int binarySearch(long value) {
        int left = 0;
        int right = this.size - 1;
        while (left <= right) {
            int mid = left + right >> 1;
            long midValue = this.elementData[mid];
            if (value == midValue) {
                return mid;
            }
            if (value < midValue) {
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return -(left + 1);
    }

    @Override
    public int indexOf(long elem) {
        int pos = this.binarySearch(elem);
        if (pos < 0) {
            return -1;
        }
        while (pos > 0 && this.elementData[pos - 1] == elem) {
            --pos;
        }
        return pos;
    }

    @Override
    public int lastIndexOf(long elem) {
        int pos = this.binarySearch(elem);
        if (pos < 0) {
            return -1;
        }
        while (pos < this.size - 1 && this.elementData[pos + 1] == elem) {
            ++pos;
        }
        return pos;
    }

    @Override
    public long set(int index, long element) {
        throw new RuntimeException("Not allowed to set specific indexes");
    }

    @Override
    public boolean add(long o) {
        int mySize = this.size();
        if (mySize == 0) {
            super.add(o);
        } else if (o >= this.elementData[mySize - 1]) {
            super.add(o);
        } else {
            int index = this.binarySearch(o);
            if (index < 0) {
                super.add(-(index + 1), o);
            } else {
                super.add(index + 1, o);
            }
        }
        return true;
    }

    @Override
    public void add(int index, long element) {
        throw new RuntimeException("Not allowed to add to specific indexes");
    }

    @Override
    public boolean removeByValue(long value) {
        int index = this.binarySearch(value);
        if (index < 0) {
            return false;
        }
        this.removeAtIndex(index);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        Iterator<? extends Long> iter = c.iterator();
        boolean didOne = false;
        while (iter.hasNext()) {
            this.add((long)iter.next());
            didOne = true;
        }
        return didOne;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        throw new RuntimeException("Not allowed to add to a specific index");
    }
}

