/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.io.TerminalWriter;
import com.aoindustries.util.AoArrays;
import com.aoindustries.util.ErrorPrinter;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class ShellInterpreter
implements Runnable {
    private static long lastPID = 0L;
    private final long pid;
    protected final Reader in;
    protected final TerminalWriter out;
    protected final TerminalWriter err;
    private final String[] args;
    private boolean isInteractive = false;
    private Thread thread;
    private ShellInterpreter parent;
    private final List<ShellInterpreter> jobs = new ArrayList<ShellInterpreter>();
    protected String status = "Running";

    public ShellInterpreter(Reader in, TerminalWriter out, TerminalWriter err) {
        this(in, out, err, AoArrays.EMPTY_STRING_ARRAY);
    }

    public ShellInterpreter(Reader in, TerminalWriter out, TerminalWriter err, String ... args) {
        this.pid = ShellInterpreter.getNextPID();
        this.in = in;
        this.out = out;
        this.err = err;
        int skipped = 0;
        for (String arg : args) {
            if ("-i".equals(arg)) {
                this.isInteractive = true;
                ++skipped;
                continue;
            }
            if (!"--".equals(arg)) break;
            ++skipped;
            break;
        }
        if (skipped == 0) {
            this.args = args;
        } else if (skipped == args.length) {
            this.args = AoArrays.EMPTY_STRING_ARRAY;
        } else {
            this.args = new String[args.length - skipped];
            System.arraycopy(args, skipped, this.args, 0, args.length - skipped);
        }
        out.setEnabled(this.isInteractive);
        err.setEnabled(this.isInteractive);
    }

    public ShellInterpreter(Reader in, Writer out, Writer err) {
        this(in, out instanceof TerminalWriter ? (TerminalWriter)out : new TerminalWriter(out), err instanceof TerminalWriter ? (TerminalWriter)err : new TerminalWriter(err));
    }

    public ShellInterpreter(Reader in, Writer out, Writer err, String[] args) {
        this(in, out instanceof TerminalWriter ? (TerminalWriter)out : new TerminalWriter(out), err instanceof TerminalWriter ? (TerminalWriter)err : new TerminalWriter(err), args);
    }

    public final void clear(String[] args) throws IOException {
        this.out.clearScreen();
    }

    protected abstract String getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextPID() {
        Class<ShellInterpreter> clazz = ShellInterpreter.class;
        synchronized (ShellInterpreter.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++lastPID;
        }
    }

    public final long getPID() {
        return this.pid;
    }

    protected abstract String getPrompt() throws IOException, SQLException;

    protected abstract boolean handleCommand(String[] var1) throws IOException, SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleCommandImpl(String[] args) throws IOException, SQLException, Throwable {
        try {
            if (args.length > 0 && "&".equals(args[args.length - 1])) {
                String[] newArgs;
                if (args.length == 1) {
                    newArgs = AoArrays.EMPTY_STRING_ARRAY;
                } else {
                    newArgs = new String[args.length - 1];
                    System.arraycopy(args, 0, newArgs, 0, args.length - 1);
                }
                ShellInterpreter shell = this.newShellInterpreter(this.in, this.out, this.err, newArgs);
                shell.parent = this;
                List<ShellInterpreter> list = this.jobs;
                synchronized (list) {
                    this.jobs.add(shell);
                    if (this.isInteractive) {
                        this.out.print('[');
                        this.out.print(this.jobs.size());
                        this.out.print("] ");
                        this.out.println(shell.pid);
                        this.out.flush();
                    }
                    shell.start();
                }
                return true;
            }
            return this.handleCommand(args);
        }
        catch (ThreadDeath TD) {
            throw TD;
        }
        catch (Throwable T) {
            if (this.isInteractive) {
                ErrorPrinter.printStackTraces(T, this.err);
                this.err.flush();
                return true;
            }
            throw T;
        }
    }

    private boolean handleCommandImpl(List<String> arguments) throws IOException, SQLException, Throwable {
        String[] myargs = new String[arguments.size()];
        arguments.toArray(myargs);
        return this.handleCommandImpl(myargs);
    }

    protected final boolean isAlive() {
        Thread t = this.thread;
        return t != null && t.isAlive();
    }

    protected final boolean isInteractive() {
        return this.isInteractive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void jobs(String[] args) {
        List<ShellInterpreter> list = this.jobs;
        synchronized (list) {
            for (int c = 0; c < this.jobs.size(); ++c) {
                ShellInterpreter job = this.jobs.get(c);
                if (job == null) continue;
                this.printJobLine(c + 1, job);
            }
        }
        this.out.flush();
    }

    protected abstract ShellInterpreter newShellInterpreter(Reader var1, TerminalWriter var2, TerminalWriter var3, String[] var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printFinishedJobs() {
        List<ShellInterpreter> list = this.jobs;
        synchronized (list) {
            boolean changed = false;
            for (int c = 0; c < this.jobs.size(); ++c) {
                ShellInterpreter shell = this.jobs.get(c);
                if (shell == null || shell.isAlive()) continue;
                shell.parent = null;
                if (this.isInteractive) {
                    this.printJobLine(c + 1, shell);
                    this.out.flush();
                }
                this.jobs.set(c, null);
                changed = true;
            }
            if (changed) {
                while (this.jobs.size() > 0 && this.jobs.get(this.jobs.size() - 1) == null) {
                    this.jobs.remove(this.jobs.size() - 1);
                }
            }
        }
    }

    private void printJobLine(int jobnum, ShellInterpreter shell) {
        int c;
        this.out.print('[');
        String num = String.valueOf(jobnum);
        this.out.print(num);
        this.out.print("] ");
        String mystatus = shell.status;
        this.out.print(mystatus);
        int blanks = Math.max(1, 25 - num.length() - mystatus.length());
        for (c = 0; c < blanks; ++c) {
            this.out.print(' ');
        }
        for (c = 0; c < shell.args.length; ++c) {
            if (c > 0) {
                this.out.print(' ');
            }
            this.out.print(shell.args[c]);
        }
        this.out.println();
    }

    @Override
    public final void run() {
        try {
            if (this.args.length > 0) {
                this.handleCommand(this.args);
            } else {
                this.runImpl();
            }
            this.status = "Done";
        }
        catch (IOException exception) {
            this.err.println(this.getName() + ": " + exception.getMessage());
            this.status = "IO Error: " + exception.getMessage();
            this.err.flush();
        }
        catch (SQLException exception) {
            this.err.println(this.getName() + ": " + exception.getMessage());
            this.status = "SQL Error: " + exception.getMessage();
            this.err.flush();
        }
        catch (ThreadDeath TD) {
            throw TD;
        }
        catch (Throwable T) {
            ErrorPrinter.printStackTraces(T, this.err);
            this.status = "Error: " + T.toString();
            this.err.flush();
        }
        finally {
            if (Thread.currentThread() == this.thread) {
                this.thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl() throws IOException, SQLException, Throwable {
        if (this.args != null && this.args.length > 0) {
            this.handleCommandImpl(this.args);
        } else {
            int ch;
            ArrayList<String> arguments = new ArrayList<String>();
            StringBuilder argument = new StringBuilder();
            boolean hasArgument = false;
            int quoteChar = -1;
            if (this.isInteractive) {
                this.out.print(this.getPrompt());
                this.out.flush();
            }
            while ((ch = this.in.read()) != -1) {
                if (ch == 13) continue;
                if (ch == 92) {
                    ch = this.in.read();
                    if (ch == -1) {
                        throw new EOFException("unexpected EOF processing escape: \\");
                    }
                    if (ch == 13 && (ch = this.in.read()) == -1) {
                        throw new EOFException("unexpected EOF processing escape: \\");
                    }
                    if (ch == 10) {
                        if (!this.isInteractive) continue;
                        this.out.print("\\> ");
                        this.out.flush();
                        continue;
                    }
                    if (quoteChar == 39 && ch != 39) {
                        argument.append('\\').append((char)ch);
                        hasArgument = true;
                        continue;
                    }
                    argument.append((char)ch);
                    hasArgument = true;
                    continue;
                }
                if (quoteChar == 39) {
                    if (ch == 39) {
                        quoteChar = -1;
                        continue;
                    }
                    argument.append((char)ch);
                    if (!this.isInteractive || ch != 10) continue;
                    this.out.print("'> ");
                    this.out.flush();
                    continue;
                }
                if (quoteChar == 34) {
                    if (ch == 34) {
                        quoteChar = -1;
                        continue;
                    }
                    argument.append((char)ch);
                    if (!this.isInteractive || ch != 10) continue;
                    this.out.print("\"> ");
                    this.out.flush();
                    continue;
                }
                if (ch == 10) {
                    if (hasArgument) {
                        arguments.add(argument.toString());
                        argument.setLength(0);
                        hasArgument = false;
                    }
                    if (this.isInteractive) {
                        this.printFinishedJobs();
                    }
                    if (arguments.size() > 0) {
                        boolean doMore = this.handleCommandImpl(arguments);
                        arguments.clear();
                        if (!doMore) break;
                    }
                    if (!this.isInteractive) continue;
                    this.out.print(this.getPrompt());
                    this.out.flush();
                    continue;
                }
                if (ch <= 32) {
                    if (!hasArgument) continue;
                    arguments.add(argument.toString());
                    argument.setLength(0);
                    hasArgument = false;
                    continue;
                }
                if (ch == 39 || ch == 34) {
                    quoteChar = ch;
                    hasArgument = true;
                    continue;
                }
                argument.append((char)ch);
                hasArgument = true;
            }
            if (quoteChar != -1) {
                throw new EOFException("unexpected EOF when processing quote: " + quoteChar);
            }
            if (hasArgument) {
                arguments.add(argument.toString());
                argument.setLength(0);
            }
            if (arguments.size() > 0) {
                this.handleCommandImpl(arguments);
                arguments.clear();
            }
            if (this.status == null || "Running".equals(this.status)) {
                this.status = "Done";
            }
        }
        ShellInterpreter myparent = this.parent;
        List<ShellInterpreter> list = this.jobs;
        synchronized (list) {
            for (ShellInterpreter shell : this.jobs) {
                shell.parent = myparent;
                if (myparent == null) continue;
                myparent.jobs.add(shell);
            }
            this.jobs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        Class<ShellInterpreter> clazz = ShellInterpreter.class;
        synchronized (ShellInterpreter.class) {
            if (this.thread != null) {
                throw new IllegalThreadStateException("Already started");
            }
            this.thread = new Thread((Runnable)this, this.getClass().getName() + "?pid=" + this.pid + (this.args.length > 0 ? "&command=" + this.args[0] : ""));
            this.thread.start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

