/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.lang.ObjectUtils;
import com.aoindustries.util.AoCollections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MinimalMap {
    private MinimalMap() {
    }

    public static <K, V> Map<K, V> put(Map<K, V> map, K key, V value) {
        if (map == null) {
            map = Collections.singletonMap(key, value);
        } else if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            K entryKey = entry.getKey();
            if (ObjectUtils.equals(key, entryKey)) {
                map = Collections.singletonMap(entryKey, value);
            } else {
                map = new LinkedHashMap(8);
                map.put(entryKey, entry.getValue());
                map.put(key, value);
            }
        } else {
            map.put(key, value);
        }
        return map;
    }

    public static <K, V> Map<K, V> remove(Map<K, V> map, K key) {
        if (map == null) {
            return null;
        }
        if (map.size() == 1) {
            if (map.containsKey(key)) {
                return null;
            }
            return map;
        }
        map.remove(key);
        if (map.size() == 1) {
            Map.Entry<K, V> entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        assert (map.size() > 1);
        return map;
    }

    public static <K, V> V get(Map<K, V> map, K key) {
        return map == null ? null : (V)map.get(key);
    }

    public static <K, V> boolean containsKey(Map<K, V> map, K key) {
        return map != null && map.containsKey(key);
    }

    public static <K, V> Collection<V> values(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        return map.values();
    }

    public static <K, V> Collection<V> valuesCopy(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        if (map.size() == 1) {
            return map.values();
        }
        return new ArrayList<V>(map.values());
    }

    public static <K, V> Map<K, V> copy(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        if (map.size() == 1) {
            return map;
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> unmodifiable(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return AoCollections.optimalUnmodifiableMap(map);
    }
}

