/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.util.LongList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.RandomAccess;

public class LongArrayList
extends AbstractList<Long>
implements LongList,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1395562938435931403L;
    protected transient long[] elementData;
    protected int size;

    public LongArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new long[initialCapacity];
    }

    public LongArrayList() {
        this(10);
    }

    public LongArrayList(Collection<? extends Number> c) {
        this.size = c.size();
        this.elementData = new long[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        Iterator<? extends Number> iter = c.iterator();
        int pos = 0;
        while (iter.hasNext()) {
            this.elementData[pos++] = iter.next().longValue();
        }
    }

    public LongArrayList(long[] elements) {
        this.size = elements.length;
        this.elementData = new long[(int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE)];
        System.arraycopy(elements, 0, this.elementData, 0, this.size);
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            long[] oldData = this.elementData;
            this.elementData = new long[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            long[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new long[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object elem) {
        if (elem == null) {
            return false;
        }
        if (elem instanceof Number) {
            return this.contains(((Number)elem).longValue());
        }
        return false;
    }

    @Override
    public boolean contains(long elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            return -1;
        }
        if (elem instanceof Number) {
            return this.indexOf(((Number)elem).longValue());
        }
        return -1;
    }

    @Override
    public int indexOf(long elem) {
        for (int i = 0; i < this.size; ++i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            return -1;
        }
        if (elem instanceof Number) {
            return this.lastIndexOf(((Number)elem).longValue());
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long elem) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (elem != this.elementData[i]) continue;
            return i;
        }
        return -1;
    }

    public Object clone() {
        try {
            LongArrayList v = (LongArrayList)super.clone();
            v.elementData = new long[this.size];
            System.arraycopy(this.elementData, 0, v.elementData, 0, this.size);
            v.modCount = 0;
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        for (int c = 0; c < this.size; ++c) {
            result[c] = this.elementData[c];
        }
        return result;
    }

    @Override
    public long[] toArrayLong() {
        long[] result = new long[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public Long get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    @Override
    public long getLong(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    @Override
    public Long set(int index, Long element) {
        return this.set(index, (long)element);
    }

    @Override
    public long set(int index, long element) {
        this.RangeCheck(index);
        long oldValue = this.elementData[index];
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(Long o) {
        return this.add((long)o);
    }

    @Override
    public boolean add(long o) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = o;
        return true;
    }

    @Override
    public void add(int index, Long element) {
        this.add(index, (long)element);
    }

    @Override
    public void add(int index, long element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    @Override
    public Long remove(int index) {
        return this.removeAtIndex(index);
    }

    @Override
    public long removeAtIndex(int index) {
        this.RangeCheck(index);
        ++this.modCount;
        long oldValue = this.elementData[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0L;
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o != null && o instanceof Number) {
            return this.removeByValue(((Number)o).longValue());
        }
        return false;
    }

    @Override
    public boolean removeByValue(long value) {
        for (int index = 0; index < this.size; ++index) {
            if (value != this.elementData[index]) continue;
            this.fastRemove(index);
            return true;
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = 0L;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = 0L;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        Iterator<? extends Long> iter = c.iterator();
        while (iter.hasNext()) {
            this.elementData[this.size++] = iter.next();
        }
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Long> c) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int numNew = c.size();
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        Iterator<? extends Long> iter = c.iterator();
        int pos = index;
        while (iter.hasNext()) {
            this.elementData[pos++] = iter.next();
        }
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = 0L;
        }
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int expectedModCount = this.modCount;
        s.defaultWriteObject();
        s.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            s.writeLong(this.elementData[i]);
        }
        if (this.modCount != expectedModCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int arrayLength = s.readInt();
        this.elementData = new long[arrayLength];
        long[] a = this.elementData;
        for (int i = 0; i < this.size; ++i) {
            a[i] = s.readLong();
        }
    }
}

