/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.util.WrappedException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public class GetOpt {
    private static final Class<?>[] parseParamTypes = new Class[]{String.class};

    private GetOpt() {
    }

    public static <T> T parse(String value, Class<T> type) {
        if (value == null) {
            throw new IllegalArgumentException("value==null");
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.TYPE || type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Float.TYPE || type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Character.TYPE || type == Character.class) {
            int len = value.length();
            if (value.length() != 1) {
                throw new IllegalArgumentException("value.length!=1: " + len);
            }
            return (T)Character.valueOf(value.charAt(0));
        }
        try {
            Method method = type.getMethod("valueOf", parseParamTypes);
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                Object result = method.invoke(null, value);
                if (result == null) {
                    throw new AssertionError((Object)"result==null");
                }
                return (T)result;
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException err) {
            throw new AssertionError((Object)err);
        }
        catch (InvocationTargetException err) {
            throw new WrappedException(err);
        }
        try {
            Constructor<T> constructor = type.getConstructor(parseParamTypes);
            return constructor.newInstance(value);
        }
        catch (NoSuchMethodException err) {
            throw new IllegalArgumentException(err);
        }
        catch (InstantiationException err) {
            throw new IllegalArgumentException(err);
        }
        catch (IllegalAccessException err) {
            throw new IllegalArgumentException(err);
        }
        catch (InvocationTargetException err) {
            throw new WrappedException(err);
        }
    }

    public static <T> T getOpt(String[] args, String name, Class<T> type) {
        String booleanPrefix = "--" + name;
        String paramPrefix = booleanPrefix + '=';
        Boolean value = null;
        for (int c = 0; c < args.length; ++c) {
            String arg = args[c];
            if (arg == null) continue;
            if ("--".equals(arg)) break;
            if (arg.startsWith(paramPrefix)) {
                value = (Boolean)GetOpt.parse(arg.substring(paramPrefix.length()), type);
                args[c] = null;
                continue;
            }
            if (type != Boolean.TYPE && type != Boolean.class || !arg.equals(booleanPrefix)) continue;
            value = Boolean.TRUE;
            args[c] = null;
        }
        return (T)value;
    }

    public static List<String> getArguments(String[] args) {
        String arg;
        int c;
        ArrayList<String> arguments = new ArrayList<String>(args.length);
        for (c = 0; c < args.length; ++c) {
            arg = args[c];
            if (arg == null) continue;
            if (arg.startsWith("--")) {
                if ("--".equals(arg)) break;
                throw new IllegalArgumentException("Unexpected parameter: " + arg);
            }
            arguments.add(arg);
        }
        while (c < args.length) {
            arg = args[c];
            if (arg != null) {
                arguments.add(arg);
            }
            ++c;
        }
        return arguments;
    }
}

