/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicLong;

public final class BufferManager {
    public static final int BUFFER_SIZE = 4096;
    private static final ThreadLocal<Deque<byte[]>> bytes = new ThreadLocal<Deque<byte[]>>(){

        @Override
        public Deque<byte[]> initialValue() {
            return new ArrayDeque<byte[]>();
        }
    };
    private static final ThreadLocal<Deque<char[]>> chars = new ThreadLocal<Deque<char[]>>(){

        @Override
        public Deque<char[]> initialValue() {
            return new ArrayDeque<char[]>();
        }
    };
    private static final AtomicLong bytesCreates = new AtomicLong();
    private static final AtomicLong bytesUses = new AtomicLong();
    private static final AtomicLong charsCreates = new AtomicLong();
    private static final AtomicLong charsUses = new AtomicLong();

    private BufferManager() {
    }

    public static byte[] getBytes() {
        bytesUses.getAndIncrement();
        byte[] buffer = bytes.get().poll();
        if (buffer == null) {
            bytesCreates.getAndIncrement();
            buffer = new byte[4096];
        }
        return buffer;
    }

    public static char[] getChars() {
        charsUses.getAndIncrement();
        char[] buffer = chars.get().poll();
        if (buffer == null) {
            charsCreates.getAndIncrement();
            buffer = new char[4096];
        }
        return buffer;
    }

    @Deprecated
    public static void release(byte[] buffer) {
        BufferManager.release(buffer, true);
    }

    public static void release(byte[] buffer, boolean zeroFill) {
        Deque<byte[]> myBytes = bytes.get();
        if (buffer.length != 4096) {
            throw new IllegalArgumentException();
        }
        assert (!BufferManager.inQueue(myBytes, buffer));
        if (zeroFill) {
            Arrays.fill(buffer, 0, 4096, (byte)0);
        }
        myBytes.add(buffer);
    }

    private static boolean inQueue(Iterable<byte[]> myBytes, byte[] buffer) {
        for (byte[] inQueue : myBytes) {
            if (inQueue != buffer) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void release(char[] buffer) {
        BufferManager.release(buffer, true);
    }

    public static void release(char[] buffer, boolean zeroFill) {
        Deque<char[]> myChars = chars.get();
        if (buffer.length != 4096) {
            throw new IllegalArgumentException();
        }
        assert (!BufferManager.inQueue(myChars, buffer));
        if (zeroFill) {
            Arrays.fill(buffer, 0, 4096, '\u0000');
        }
        myChars.add(buffer);
    }

    private static boolean inQueue(Iterable<char[]> myChars, char[] buffer) {
        for (char[] inQueue : myChars) {
            if (inQueue != buffer) continue;
            return true;
        }
        return false;
    }

    public static long getByteBufferCreates() {
        return bytesCreates.get();
    }

    public static long getByteBufferUses() {
        return bytesUses.get();
    }

    public static long getCharBufferCreates() {
        return charsCreates.get();
    }

    public static long getCharBufferUses() {
        return charsUses.get();
    }
}

