/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ArraySortedSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Serializable {
    private static final long serialVersionUID = -8200779660844889853L;
    private final Comparator<? super E> comparator;
    private final ArrayList<E> elements;

    public ArraySortedSet() {
        this.comparator = null;
        this.elements = new ArrayList();
    }

    public ArraySortedSet(int initialCapacity) {
        this.comparator = null;
        this.elements = new ArrayList(initialCapacity);
    }

    public ArraySortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
        this.elements = new ArrayList();
    }

    public ArraySortedSet(Comparator<? super E> comparator, int initialCapacity) {
        this.comparator = comparator;
        this.elements = new ArrayList(initialCapacity);
    }

    public ArraySortedSet(Collection<? extends E> c) {
        this.comparator = null;
        this.elements = new ArrayList(c.size());
        this.addAll(c);
    }

    public ArraySortedSet(SortedSet<E> s) {
        this.comparator = s.comparator();
        this.elements = new ArrayList<E>(s);
    }

    private int binarySearch(E elem) {
        return this.comparator == null ? Collections.binarySearch(this.elements, elem) : Collections.binarySearch(this.elements, elem, this.comparator);
    }

    private int compare(E elem1, E elem2) {
        return this.comparator == null ? ((Comparable)elem1).compareTo(elem2) : this.comparator.compare(elem1, elem2);
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException("TODO: Not supported yet.");
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException("TODO: Not supported yet.");
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException("TODO: Not supported yet.");
    }

    @Override
    public E first() {
        if (this.elements.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.elements.get(0);
    }

    @Override
    public E last() {
        int size = this.elements.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return this.elements.get(size - 1);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.binarySearch(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean add(E e) {
        int size = this.elements.size();
        if (size == 0) {
            this.elements.add(e);
            return true;
        }
        E last = this.elements.get(size - 1);
        int diff = this.compare(e, last);
        if (diff > 0) {
            this.elements.add(e);
            return true;
        }
        if (diff == 0) {
            return false;
        }
        int index = this.binarySearch(e);
        if (index >= 0) {
            return false;
        }
        throw new UnsupportedOperationException("May only add the last element.");
    }

    @Override
    public boolean remove(Object o) {
        int size = this.elements.size();
        if (size == 0) {
            return false;
        }
        E lastElem = this.elements.get(size - 1);
        if (this.compare(lastElem, o) == 0) {
            this.elements.remove(size - 1);
            return true;
        }
        if (this.contains(o)) {
            throw new UnsupportedOperationException("May only remove the last element.");
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E elem : c) {
            if (!this.add(elem)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.elements.clear();
    }
}

