/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.util;

import com.aoindustries.lang.ObjectUtils;
import com.aoindustries.util.AoCollections;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Set;

public class AoArrays {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Serializable[] EMPTY_SERIALIZABLE_ARRAY = new Serializable[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private AoArrays() {
    }

    public static boolean equals(byte[] b1, byte[] b2, int off, int len) {
        int end = off + len;
        while (off < end) {
            if (b1[off] != b2[off]) {
                return false;
            }
            ++off;
        }
        return true;
    }

    public static boolean equals(byte[] b1, int off1, byte[] b2, int off2, int len) {
        int end = off1 + len;
        while (off1 < end) {
            if (b1[off1] != b2[off2]) {
                return false;
            }
            ++off1;
            ++off2;
        }
        return true;
    }

    public static boolean allEquals(byte[] b, int off, int len, byte value) {
        int end = off + len;
        while (off < end) {
            if (b[off] != value) {
                return false;
            }
            ++off;
        }
        return true;
    }

    public static int compare(byte[] ba1, byte[] ba2) {
        int len = Math.min(ba1.length, ba2.length);
        for (int i = 0; i < len; ++i) {
            int b1 = ba1[i] & 0xFF;
            int b2 = ba2[i] & 0xFF;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        if (ba1.length > len) {
            return 1;
        }
        if (ba2.length > len) {
            return -1;
        }
        return 0;
    }

    public static <V> V[] merge(Class<V> clazz, Collection<? extends Collection<? extends V>> collections, final Comparator<? super V> comparator) {
        AoCollections.PeekIterator pi;
        int numCollections = collections.size();
        if (numCollections == 0) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        if (numCollections == 1) {
            Collection<V> collection = collections.iterator().next();
            return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
        }
        if (numCollections == 2) {
            Iterator<Collection<V>> collIter = collections.iterator();
            Collection<V> c1 = collIter.next();
            Collection<V> c2 = collIter.next();
            assert (!collIter.hasNext());
            Iterator<V> i1 = c1.iterator();
            Iterator<V> i2 = c2.iterator();
            int totalSize = c1.size() + c2.size();
            Object[] results = (Object[])Array.newInstance(clazz, totalSize);
            Object next1 = i1.hasNext() ? i1.next() : null;
            Object next2 = i2.hasNext() ? i2.next() : null;
            int pos = 0;
            while (true) {
                if (next1 == null) {
                    if (next2 == null) break;
                    results[pos++] = next2;
                    while (i2.hasNext()) {
                        results[pos++] = i2.next();
                    }
                    break;
                }
                if (next2 == null) {
                    results[pos++] = next1;
                    while (i1.hasNext()) {
                        results[pos++] = i1.next();
                    }
                    break;
                }
                if (comparator.compare(next1, next2) <= 0) {
                    results[pos++] = next1;
                    next1 = i1.hasNext() ? i1.next() : null;
                    continue;
                }
                results[pos++] = next2;
                next2 = i2.hasNext() ? i2.next() : null;
            }
            if (pos != totalSize) {
                throw new ConcurrentModificationException();
            }
            return results;
        }
        PriorityQueue<AoCollections.PeekIterator> pq = new PriorityQueue<AoCollections.PeekIterator>(numCollections, new Comparator<AoCollections.PeekIterator<? extends V>>(){

            @Override
            public int compare(AoCollections.PeekIterator<? extends V> i1, AoCollections.PeekIterator<? extends V> i2) {
                return comparator.compare(i1.peek(), i2.peek());
            }
        });
        int totalSize = 0;
        for (Collection<V> collection : collections) {
            pq.add(AoCollections.peekIterator(collection.iterator()));
            totalSize += collection.size();
        }
        Object[] results = (Object[])Array.newInstance(clazz, totalSize);
        int pos = 0;
        while ((pi = (AoCollections.PeekIterator)pq.poll()) != null) {
            results[pos++] = pi.next();
            if (!pi.hasNext()) continue;
            pq.offer(pi);
        }
        if (pos != totalSize) {
            throw new ConcurrentModificationException();
        }
        return results;
    }

    public static <E> Set<E> asUnmodifiableSet(E ... array) {
        int len = array.length;
        if (len == 0) {
            return Collections.emptySet();
        }
        if (len == 1) {
            return Collections.singleton(array[0]);
        }
        return new UnmodifiableArraySet<E>(array);
    }

    public static <E> int indexOf(E[] array, E element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static <E> int indexOf(E[] array, E element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (!ObjectUtils.equals(array[i], element)) continue;
            return i;
        }
        return -1;
    }

    public static <E> int lastIndexOf(E[] array, E element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static <E> int lastIndexOf(E[] array, E element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (!ObjectUtils.equals(array[i], element)) continue;
            return i;
        }
        return -1;
    }

    public static <E extends Enum<E>> int indexOf(E[] array, E element) {
        return AoArrays.indexOf(array, element, (int)0);
    }

    public static <E extends Enum<E>> int indexOf(E[] array, E element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static <E extends Enum<E>> int lastIndexOf(E[] array, E element) {
        return AoArrays.lastIndexOf(array, element, (int)(array.length - 1));
    }

    public static <E extends Enum<E>> int lastIndexOf(E[] array, E element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, byte element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static int indexOf(byte[] array, byte element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static int lastIndexOf(byte[] array, byte element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short[] array, short element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static int indexOf(short[] array, short element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static int lastIndexOf(short[] array, short element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static int indexOf(int[] array, int element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static int lastIndexOf(int[] array, int element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long[] array, long element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static int indexOf(long[] array, long element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static int lastIndexOf(long[] array, long element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array, float element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static int indexOf(float[] array, float element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static int lastIndexOf(float[] array, float element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static int indexOf(double[] array, double element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static int lastIndexOf(double[] array, double element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char[] array, char element) {
        return AoArrays.indexOf(array, element, 0);
    }

    public static int indexOf(char[] array, char element, int fromIndex) {
        int len = array.length;
        for (int i = fromIndex; i < len; ++i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char element) {
        return AoArrays.lastIndexOf(array, element, array.length - 1);
    }

    public static int lastIndexOf(char[] array, char element, int fromIndex) {
        for (int i = fromIndex; i >= 0; --i) {
            if (array[i] != element) continue;
            return i;
        }
        return -1;
    }

    public static int hashCode(byte[] a, int off, int len) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        int end = off + len;
        while (off < end) {
            result = 31 * result + a[off];
            ++off;
        }
        return result;
    }

    static final class UnmodifiableArraySet<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final E[] array;

        UnmodifiableArraySet(E[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public boolean isEmpty() {
            return this.array.length == 0;
        }

        @Override
        public boolean contains(Object o) {
            E[] a = this.array;
            int len = a.length;
            if (o == null) {
                for (int i = 0; i < len; ++i) {
                    if (a[i] != null) continue;
                    return true;
                }
            } else {
                int i = len - 1;
                while (i >= 0) {
                    if (!o.equals(a[i--])) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                int pos = 0;

                @Override
                public boolean hasNext() {
                    return this.pos < UnmodifiableArraySet.this.array.length;
                }

                @Override
                public E next() throws NoSuchElementException {
                    if (this.pos < UnmodifiableArraySet.this.array.length) {
                        return UnmodifiableArraySet.this.array[this.pos++];
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() throws UnsupportedOperationException {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            int len = this.array.length;
            Object[] resultArray = new Object[len];
            System.arraycopy(this.array, 0, resultArray, 0, len);
            return resultArray;
        }

        @Override
        public <T> T[] toArray(T[] resultArray) {
            int len = this.array.length;
            resultArray = resultArray.length >= len ? resultArray : (Object[])Array.newInstance(resultArray.getClass().getComponentType(), len);
            System.arraycopy(this.array, 0, resultArray, 0, len);
            if (resultArray.length > len) {
                resultArray[len] = null;
            }
            return resultArray;
        }

        @Override
        public boolean add(E e) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

