/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.swing;

import com.aoindustries.swing.ApplicationResources;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;

public class SynchronizingComboBoxModel<E>
extends DefaultComboBoxModel {
    private static final long serialVersionUID = 2421298474426921512L;
    private final E constantFirstRow;

    public SynchronizingComboBoxModel() {
        this.constantFirstRow = null;
    }

    public SynchronizingComboBoxModel(E constantFirstRow) {
        this.constantFirstRow = constantFirstRow;
        this.addElement(constantFirstRow);
    }

    public void synchronize(List<? extends E> list) {
        int modelOffset;
        assert (SwingUtilities.isEventDispatchThread()) : ApplicationResources.accessor.getMessage("assert.notRunningInSwingEventThread");
        if (this.constantFirstRow != null) {
            modelOffset = 1;
            if (this.getSize() == 0) {
                this.addElement(this.constantFirstRow);
            } else if (!this.getElementAt(0).equals(this.constantFirstRow)) {
                this.insertElementAt(this.constantFirstRow, 0);
            }
        } else {
            modelOffset = 0;
        }
        int size = list.size();
        for (int index = 0; index < size; ++index) {
            E obj = list.get(index);
            if (index >= this.getSize() - modelOffset) {
                this.addElement(obj);
                continue;
            }
            if (obj.equals(this.getElementAt(index + modelOffset))) continue;
            int foundIndex = -1;
            for (int searchIndex = index + 1; searchIndex < this.getSize() - modelOffset; ++searchIndex) {
                if (!obj.equals(this.getElementAt(searchIndex + modelOffset))) continue;
                foundIndex = searchIndex;
                break;
            }
            if (foundIndex != -1) {
                int end = index + modelOffset;
                for (int removeIndex = foundIndex - 1 + modelOffset; removeIndex >= end; --removeIndex) {
                    this.removeElementAt(removeIndex);
                }
                continue;
            }
            this.insertElementAt(obj, index + modelOffset);
        }
        while (this.getSize() - modelOffset > size) {
            this.removeElementAt(this.getSize() - 1);
        }
    }
}

