/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ImageCanvas
extends JComponent {
    private static final long serialVersionUID = -6487381720349856719L;
    final Image image;
    final Window window;
    private long nextupdate;
    private boolean resized = false;

    public ImageCanvas(Image image) {
        this.image = image;
        this.window = null;
    }

    public ImageCanvas(URL url) {
        this.image = Toolkit.getDefaultToolkit().getImage(url);
        this.window = null;
    }

    public ImageCanvas(URL url, Window window) {
        this.image = Toolkit.getDefaultToolkit().getImage(url);
        this.window = window;
    }

    @Override
    public Dimension getPreferredSize() {
        int iwidth = this.image.getWidth(this);
        int iheight = this.image.getHeight(this);
        if (iwidth > 0 && iheight > 0) {
            return new Dimension(iwidth, iheight);
        }
        return new Dimension(0, 0);
    }

    @Override
    public synchronized boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 8) != 0) {
            long time = System.currentTimeMillis();
            if (time >= this.nextupdate) {
                this.repaint();
                this.nextupdate = time + 500L;
            }
        } else if ((flags & 0x30) != 0) {
            if (!this.resized) {
                this.resizeIt();
            }
            this.repaint();
        } else if ((flags & 3) != 0) {
            int iwidth = this.image.getWidth(this);
            int iheight = this.image.getHeight(this);
            if (iwidth > 0 && iheight > 0) {
                this.resizeIt();
            }
        }
        return (flags & 0xE0) == 0;
    }

    @Override
    public void paint(Graphics G) {
        if (G != null) {
            int iheight;
            int iwidth;
            int height;
            Dimension D = this.getSize();
            int width = D.width;
            if (width > 0 && (height = D.height) > 0 && (iwidth = this.image.getWidth(this)) > 0 && (iheight = this.image.getHeight(this)) > 0) {
                Color background = this.getBackground();
                G.setColor(background);
                int temp = iheight * width / iwidth;
                if (temp <= height) {
                    int y1 = (height - temp) / 2;
                    G.fillRect(0, 0, width, y1);
                    G.drawImage(this.image, 0, y1, width, temp, background, this);
                    G.fillRect(0, y1 + temp, width, height - y1 - temp);
                } else {
                    temp = iwidth * height / iheight;
                    int x1 = (width - temp) / 2;
                    G.fillRect(0, 0, x1, height);
                    G.drawImage(this.image, x1, 0, temp, height, background, this);
                    G.fillRect(x1 + temp, 0, width - x1 - temp, height);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizeIt() {
        if (this.window != null) {
            Window window = this.window;
            synchronized (window) {
                this.window.pack();
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageCanvas.this.getParent().invalidate();
                    ImageCanvas.this.getParent().validate();
                }
            });
        }
        this.resized = true;
    }

    @Override
    public void update(Graphics G) {
        this.paint(G);
    }
}

