/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.security;

import com.aoindustries.math.LongLong;
import com.aoindustries.math.UnsignedLong;
import com.aoindustries.util.persistent.PersistentCollections;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class Identifier
implements Serializable,
Comparable<Identifier> {
    private static final long serialVersionUID = 1L;
    static final long BASE = 57L;
    private static final char[] characters = new char[]{'A', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'R', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char LOWEST_CHAR = '0';
    private static final char HIGHEST_CHAR = 'z';
    private static final int[] values;
    static final SecureRandom secureRandom;
    private final long hi;
    private final long lo;

    public static Identifier valueOf(String encoded) throws IllegalArgumentException {
        return new Identifier(encoded);
    }

    static char getCharacter(long value) {
        int index = (int)UnsignedLong.remainder(value, 57L);
        return characters[index];
    }

    private static long getValue(char ch) {
        int value;
        if (ch >= '0' && ch <= 'z' && (value = values[ch - 48]) != -1) {
            return value;
        }
        throw new IllegalArgumentException(Character.toString(ch));
    }

    static long decode(String encoded) {
        assert (encoded.length() == 11);
        return Identifier.getValue(encoded.charAt(0)) * 57L * 57L * 57L * 57L * 57L * 57L * 57L * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(1)) * 57L * 57L * 57L * 57L * 57L * 57L * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(2)) * 57L * 57L * 57L * 57L * 57L * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(3)) * 57L * 57L * 57L * 57L * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(4)) * 57L * 57L * 57L * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(5)) * 57L * 57L * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(6)) * 57L * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(7)) * 57L * 57L * 57L + Identifier.getValue(encoded.charAt(8)) * 57L * 57L + Identifier.getValue(encoded.charAt(9)) * 57L + Identifier.getValue(encoded.charAt(10));
    }

    public Identifier() {
        this(secureRandom);
    }

    public Identifier(Random random) {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        this.hi = PersistentCollections.bufferToLong(bytes);
        this.lo = PersistentCollections.bufferToLong(bytes, 8);
    }

    public Identifier(long hi, long lo) {
        this.hi = hi;
        this.lo = lo;
    }

    public Identifier(String encoded) throws IllegalArgumentException {
        if (encoded.length() != 22) {
            throw new IllegalArgumentException();
        }
        this.hi = Identifier.decode(encoded.substring(0, 11));
        this.lo = Identifier.decode(encoded.substring(11));
    }

    public boolean equals(Object O) {
        if (!(O instanceof Identifier)) {
            return false;
        }
        return this.equals((Identifier)O);
    }

    public boolean equals(Identifier other) {
        return other != null && this.hi == other.hi && this.lo == other.lo;
    }

    public int hashCode() {
        return (int)this.lo;
    }

    public String toString() {
        return new String(new char[]{Identifier.getCharacter(UnsignedLong.divide(this.hi, 362033331456891249L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 6351461955384057L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 111429157112001L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 1954897493193L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 34296447249L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 601692057L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 10556001L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 185193L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 3249L)), Identifier.getCharacter(UnsignedLong.divide(this.hi, 57L)), Identifier.getCharacter(this.hi), Identifier.getCharacter(UnsignedLong.divide(this.lo, 362033331456891249L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 6351461955384057L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 111429157112001L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 1954897493193L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 34296447249L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 601692057L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 10556001L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 185193L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 3249L)), Identifier.getCharacter(UnsignedLong.divide(this.lo, 57L)), Identifier.getCharacter(this.lo)});
    }

    @Override
    public int compareTo(Identifier other) {
        int diff = LongLong.compareUnsigned(this.hi, other.hi);
        if (diff != 0) {
            return diff;
        }
        return LongLong.compareUnsigned(this.lo, other.lo);
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public static void main(String[] args) {
        System.out.println(new Identifier());
    }

    static {
        assert ((long)characters.length == 57L);
        values = new int[75];
        Arrays.fill(values, -1);
        int i = 0;
        while ((long)i < 57L) {
            Identifier.values[Identifier.characters[i] - 48] = i;
            ++i;
        }
        secureRandom = new SecureRandom();
    }
}

