/*
 * Decompiled with CFR 0.152.
 */
package com.aoindustries.net;

import com.aoindustries.net.EmptyParameters;
import com.aoindustries.net.HttpParameters;
import com.aoindustries.net.ServletRequestParameters;
import com.aoindustries.util.AoCollections;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UnmodifiableHttpParameters
implements HttpParameters {
    private final HttpParameters wrapped;

    public static HttpParameters wrap(HttpParameters wrapped) {
        if (wrapped == EmptyParameters.getInstance()) {
            return wrapped;
        }
        if (wrapped instanceof ServletRequestParameters) {
            return wrapped;
        }
        if (wrapped instanceof UnmodifiableHttpParameters) {
            return wrapped;
        }
        return new UnmodifiableHttpParameters(wrapped);
    }

    private UnmodifiableHttpParameters(HttpParameters wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public String getParameter(String name) {
        return this.wrapped.getParameter(name);
    }

    @Override
    public Iterator<String> getParameterNames() {
        return AoCollections.unmodifiableIterator(this.wrapped.getParameterNames());
    }

    @Override
    public List<String> getParameterValues(String name) {
        return Collections.unmodifiableList(this.wrapped.getParameterValues(name));
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        Map<String, List<String>> wrappedMap = this.wrapped.getParameterMap();
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>(wrappedMap.size() * 4 / 3 + 1);
        for (Map.Entry<String, List<String>> entry : wrappedMap.entrySet()) {
            map.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }
}

